/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncMongoClient;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

class KeyRetriever
implements Closeable {
    private final AsyncMongoClient client;
    private final boolean ownsClient;
    private final MongoNamespace namespace;

    KeyRetriever(AsyncMongoClient client, boolean ownsClient, MongoNamespace namespace) {
        this.client = Assertions.notNull("client", client);
        this.ownsClient = ownsClient;
        this.namespace = Assertions.notNull("namespace", namespace);
    }

    public void find(BsonDocument keyFilter, SingleResultCallback<List<BsonDocument>> callback) {
        this.client.getDatabase(this.namespace.getDatabaseName()).getCollection(this.namespace.getCollectionName(), BsonDocument.class).withReadConcern(ReadConcern.MAJORITY).find((Bson)keyFilter).into(new ArrayList(), callback);
    }

    @Override
    public void close() {
        if (this.ownsClient) {
            this.client.close();
        }
    }
}

