/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.ClientSessionOptions;
import com.mongodb.Function;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncChangeStreamIterable;
import com.mongodb.internal.async.client.AsyncChangeStreamIterableImpl;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.async.client.AsyncListDatabasesIterable;
import com.mongodb.internal.async.client.AsyncListDatabasesIterableImpl;
import com.mongodb.internal.async.client.AsyncMongoClient;
import com.mongodb.internal.async.client.AsyncMongoDatabase;
import com.mongodb.internal.async.client.AsyncMongoDatabaseImpl;
import com.mongodb.internal.async.client.AsyncMongoIterable;
import com.mongodb.internal.async.client.ClientSessionHelper;
import com.mongodb.internal.async.client.Crypt;
import com.mongodb.internal.async.client.Crypts;
import com.mongodb.internal.async.client.OperationExecutor;
import com.mongodb.internal.async.client.OperationExecutorImpl;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.lang.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.internal.CodecRegistryHelper;

class AsyncMongoClientImpl
implements AsyncMongoClient {
    private static final Logger LOGGER = Loggers.getLogger("client");
    private final Cluster cluster;
    private final MongoClientSettings settings;
    private final OperationExecutor executor;
    private final Closeable externalResourceCloser;
    private final ServerSessionPool serverSessionPool;
    private final ClientSessionHelper clientSessionHelper;
    private final CodecRegistry codecRegistry;
    private final Crypt crypt;

    AsyncMongoClientImpl(MongoClientSettings settings, Cluster cluster, @Nullable Closeable externalResourceCloser) {
        this(settings, cluster, null, externalResourceCloser);
    }

    AsyncMongoClientImpl(MongoClientSettings settings, Cluster cluster, @Nullable OperationExecutor executor) {
        this(settings, cluster, executor, null);
    }

    private AsyncMongoClientImpl(MongoClientSettings settings, Cluster cluster, @Nullable OperationExecutor executor, @Nullable Closeable externalResourceCloser) {
        this.settings = Assertions.notNull("settings", settings);
        this.cluster = Assertions.notNull("cluster", cluster);
        this.serverSessionPool = new ServerSessionPool(cluster);
        this.clientSessionHelper = new ClientSessionHelper(this, this.serverSessionPool);
        AutoEncryptionSettings autoEncryptSettings = settings.getAutoEncryptionSettings();
        this.crypt = autoEncryptSettings != null ? Crypts.createCrypt(this, autoEncryptSettings) : null;
        this.executor = executor == null ? new OperationExecutorImpl(this, this.clientSessionHelper) : executor;
        this.externalResourceCloser = externalResourceCloser;
        this.codecRegistry = CodecRegistryHelper.createRegistry((CodecRegistry)settings.getCodecRegistry(), (UuidRepresentation)settings.getUuidRepresentation());
    }

    @Override
    public void startSession(SingleResultCallback<AsyncClientSession> callback) {
        this.startSession(ClientSessionOptions.builder().build(), callback);
    }

    @Override
    public void startSession(ClientSessionOptions options, final SingleResultCallback<AsyncClientSession> callback) {
        Assertions.notNull("callback", callback);
        this.clientSessionHelper.createClientSession(Assertions.notNull("options", options), this.executor, new SingleResultCallback<AsyncClientSession>(){

            @Override
            public void onResult(AsyncClientSession clientSession, Throwable t) {
                SingleResultCallback<AsyncClientSession> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else if (clientSession == null) {
                    errHandlingCallback.onResult(null, new MongoClientException("Sessions are not supported by the MongoDB cluster to which this client is connected"));
                } else {
                    errHandlingCallback.onResult(clientSession, null);
                }
            }
        });
    }

    @Override
    public AsyncMongoDatabase getDatabase(String name) {
        return new AsyncMongoDatabaseImpl(name, this.codecRegistry, this.settings.getReadPreference(), this.settings.getWriteConcern(), this.settings.getRetryWrites(), this.settings.getRetryReads(), this.settings.getReadConcern(), this.settings.getUuidRepresentation(), this.executor);
    }

    @Override
    public void close() {
        if (this.crypt != null) {
            this.crypt.close();
        }
        this.serverSessionPool.close();
        this.cluster.close();
        if (this.externalResourceCloser != null) {
            try {
                this.externalResourceCloser.close();
            }
            catch (IOException e) {
                LOGGER.warn("Exception closing resource", e);
            }
        }
    }

    @Override
    public AsyncMongoIterable<String> listDatabaseNames() {
        return this.createListDatabaseNamesIterable(null);
    }

    @Override
    public AsyncMongoIterable<String> listDatabaseNames(AsyncClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListDatabaseNamesIterable(clientSession);
    }

    private AsyncMongoIterable<String> createListDatabaseNamesIterable(@Nullable AsyncClientSession clientSession) {
        return this.createListDatabasesIterable(clientSession, BsonDocument.class).nameOnly(true).map(new Function<BsonDocument, String>(){

            @Override
            public String apply(BsonDocument result) {
                return result.getString((Object)"name").getValue();
            }
        });
    }

    @Override
    public AsyncListDatabasesIterable<Document> listDatabases() {
        return this.createListDatabasesIterable(null, Document.class);
    }

    @Override
    public AsyncListDatabasesIterable<Document> listDatabases(AsyncClientSession clientSession) {
        return this.listDatabases(clientSession, Document.class);
    }

    public <T> AsyncListDatabasesIterable<T> listDatabases(Class<T> resultClass) {
        return this.createListDatabasesIterable(null, resultClass);
    }

    @Override
    public <TResult> AsyncListDatabasesIterable<TResult> listDatabases(AsyncClientSession clientSession, Class<TResult> resultClass) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListDatabasesIterable(clientSession, resultClass);
    }

    @Override
    public AsyncChangeStreamIterable<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    @Override
    public <TResult> AsyncChangeStreamIterable<TResult> watch(Class<TResult> resultClass) {
        return this.watch(Collections.emptyList(), resultClass);
    }

    @Override
    public AsyncChangeStreamIterable<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, Document.class);
    }

    @Override
    public <TResult> AsyncChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createChangeStreamIterable(null, pipeline, resultClass);
    }

    @Override
    public AsyncChangeStreamIterable<Document> watch(AsyncClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList(), Document.class);
    }

    @Override
    public <TResult> AsyncChangeStreamIterable<TResult> watch(AsyncClientSession clientSession, Class<TResult> resultClass) {
        return this.watch(clientSession, Collections.emptyList(), resultClass);
    }

    @Override
    public AsyncChangeStreamIterable<Document> watch(AsyncClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> AsyncChangeStreamIterable<TResult> watch(AsyncClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull("clientSession", clientSession);
        return this.createChangeStreamIterable(clientSession, pipeline, resultClass);
    }

    @Override
    public ClusterDescription getClusterDescription() {
        return this.cluster.getCurrentDescription();
    }

    private <TResult> AsyncChangeStreamIterable<TResult> createChangeStreamIterable(@Nullable AsyncClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new AsyncChangeStreamIterableImpl<TResult>(clientSession, "admin", this.codecRegistry, this.settings.getReadPreference(), this.settings.getReadConcern(), this.executor, pipeline, resultClass, ChangeStreamLevel.CLIENT, this.settings.getRetryReads());
    }

    private <T> AsyncListDatabasesIterable<T> createListDatabasesIterable(@Nullable AsyncClientSession clientSession, Class<T> clazz) {
        return new AsyncListDatabasesIterableImpl<T>(clientSession, clazz, this.codecRegistry, ReadPreference.primary(), this.executor, this.settings.getRetryReads());
    }

    MongoClientSettings getSettings() {
        return this.settings;
    }

    Cluster getCluster() {
        return this.cluster;
    }

    ServerSessionPool getServerSessionPool() {
        return this.serverSessionPool;
    }

    Crypt getCrypt() {
        return this.crypt;
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }
}

