/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.schemagenerator.maven;

import io.debezium.schemagenerator.SchemaGenerator;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;

@Mojo(name="generate-api-spec", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class SchemaGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="openapi", property="schema.format")
    private String format;
    @Parameter(defaultValue="${project.build.directory}${file.separator}generated-sources", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="false")
    private boolean groupDirectoryPerConnector;
    @Parameter(defaultValue="")
    private String filenamePrefix = "";
    @Parameter(defaultValue="")
    private String filenameSuffix = "";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> remoteRepos;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String classPath = this.getClassPath();
        try {
            int result = this.exec(SchemaGenerator.class.getName(), classPath, Collections.emptyList(), Arrays.asList(this.format, this.outputDirectory.getAbsolutePath(), String.valueOf(this.groupDirectoryPerConnector), SchemaGeneratorMojo.quoteIfNecessary(this.filenamePrefix), SchemaGeneratorMojo.quoteIfNecessary(this.filenameSuffix)));
            if (result != 0) {
                throw new MojoExecutionException("Couldn't generate API spec; please see the logs for more details");
            }
            this.getLog().info((CharSequence)("Generated API spec at " + this.outputDirectory.getAbsolutePath()));
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Couldn't generate API spec", e);
        }
    }

    private int exec(String className, String classPath, List<String> jvmArgs, List<String> args) throws IOException, InterruptedException {
        this.getLog().debug((CharSequence)("Executing SchemaGenerator with classpath: " + classPath));
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaBin);
        command.addAll(jvmArgs);
        command.add("-cp");
        command.add(classPath);
        command.add(className);
        command.addAll(args);
        ProcessBuilder builder = new ProcessBuilder(command);
        Process process = builder.inheritIO().start();
        process.waitFor();
        return process.exitValue();
    }

    private String getClassPath() throws MojoExecutionException {
        Set dependencyArtifacts = this.project.getArtifacts();
        Set<Artifact> pluginDependencyArtifacts = this.getDependencies(this.getGeneratorPluginArtifact());
        Object classPath = dependencyArtifacts.stream().filter(a -> a.getScope().equals("compile") || a.getScope().equals("provided")).map(a -> a.getFile().getAbsolutePath()).collect(Collectors.joining(File.pathSeparator));
        classPath = (String)classPath + File.pathSeparator + pluginDependencyArtifacts.stream().map(a -> a.getFile().getAbsolutePath()).collect(Collectors.joining(File.pathSeparator));
        classPath = (String)classPath + File.pathSeparator + this.classPathEntryFor(SchemaGenerator.class);
        classPath = (String)classPath + File.pathSeparator + this.project.getArtifact().getFile().getAbsolutePath();
        return classPath;
    }

    private org.apache.maven.artifact.Artifact getGeneratorPluginArtifact() {
        Set pluginArtifacts = this.project.getPluginArtifacts();
        return pluginArtifacts.stream().filter(a -> a.getArtifactId().equals("debezium-schema-generator")).findFirst().get();
    }

    private String classPathEntryFor(Class<?> clazz) {
        try {
            return new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()).getAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<Artifact> getDependencies(org.apache.maven.artifact.Artifact inputArtifact) throws MojoExecutionException {
        try {
            DefaultArtifact artifact = new DefaultArtifact(inputArtifact.getGroupId(), inputArtifact.getArtifactId(), null, inputArtifact.getVersion());
            CollectRequest collectRequest = new CollectRequest(new Dependency((Artifact)artifact, "compile"), this.remoteRepos);
            CollectResult collectResult = this.repoSystem.collectDependencies(this.repoSession, collectRequest);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            collectResult.getRoot().accept((DependencyVisitor)nlg);
            List dependencies = nlg.getNodes();
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                DependencyNode next = (DependencyNode)it.next();
                if (next.getDependency() != collectRequest.getRoot()) continue;
                it.remove();
            }
            return dependencies.stream().filter(d -> d.getDependency() != collectRequest.getRoot()).map(d -> this.resolveArtifact(d.getArtifact())).collect(Collectors.toSet());
        }
        catch (DependencyCollectionException e) {
            throw new MojoExecutionException("Couldn't collect dependencies of artifact " + inputArtifact, (Exception)((Object)e));
        }
    }

    private Artifact resolveArtifact(Artifact inputArtifact) {
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact(inputArtifact);
        request.setRepositories(this.remoteRepos);
        try {
            return this.repoSystem.resolveArtifact(this.repoSession, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static boolean isWindows() {
        String operatingSystemName = System.getProperty("os.name");
        return operatingSystemName != null && operatingSystemName.startsWith("Windows");
    }

    private static String quoteIfNecessary(String value) {
        if ((value == null || value.length() == 0) && SchemaGeneratorMojo.isWindows()) {
            return "\"\"";
        }
        return value;
    }
}

