/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.internal;

import io.debezium.DebeziumException;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmRootEntityType;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.spi.MetadataSourcesContributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumOutboxMetadataSourcesContributor
implements MetadataSourcesContributor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebeziumOutboxMetadataSourcesContributor.class);

    public void contribute(MetadataSources metadataSources) {
        Origin origin = new Origin(SourceType.FILE, "META-INF/OutboxEvent.hbm.xml");
        try (InputStream stream = this.getOutboxHbmXmlStream();){
            if (stream == null) {
                LOGGER.error("Failed to locate OutboxEvent.hbm.xml on classpath");
                return;
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        writer.write(line);
                    }
                    ((Writer)writer).flush();
                }
                try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                     BufferedInputStream bis = new BufferedInputStream(bais);){
                    MappingBinder mappingBinder = metadataSources.getXmlMappingBinderAccess().getMappingBinder();
                    Binding jaxbBinding = mappingBinder.bind((InputStream)bis, origin);
                    metadataSources.addXmlBinding(jaxbBinding);
                    JaxbHbmHibernateMapping mapping = (JaxbHbmHibernateMapping)jaxbBinding.getRoot();
                    this.logOutboxMapping(mapping);
                    LOGGER.info("Contributed XML mapping for entity: {}", (Object)((JaxbHbmRootEntityType)mapping.getClazz().get(0)).getEntityName());
                }
            }
        }
        catch (IOException e) {
            throw new DebeziumException("Failed to read OutboxEvent.hbm.xml", (Throwable)e);
        }
    }

    private InputStream getOutboxHbmXmlStream() {
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        InputStream stream = currentThreadClassLoader.getResourceAsStream("/META-INF/OutboxEvent.hbm.xml");
        if (stream != null) {
            return stream;
        }
        return this.getClass().getResourceAsStream("/META-INF/OutboxEvent.hbm.xml");
    }

    private void logOutboxMapping(JaxbHbmHibernateMapping mapping) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{JaxbHbmHibernateMapping.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)mapping, (Writer)writer);
            LOGGER.debug("Debezium Outbox XML Mapping:\n{}", (Object)writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to marshal Debezium Outbox XML mapping", e);
        }
    }
}

