/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.openlineage.emitter;

import io.debezium.connector.common.DebeziumTaskState;
import io.debezium.openlineage.ConnectorContext;
import io.debezium.openlineage.OpenLineageContext;
import io.debezium.openlineage.OpenLineageJobCreator;
import io.debezium.openlineage.ProcessingEngineMetadata;
import io.debezium.openlineage.dataset.DatasetMetadata;
import io.debezium.openlineage.dataset.DatasetNamespaceResolver;
import io.debezium.openlineage.dataset.DatasetNamespaceResolverFactory;
import io.debezium.openlineage.emitter.DebeziumOpenLineageClient;
import io.debezium.openlineage.emitter.LineageEmitter;
import io.debezium.openlineage.facets.DebeziumConfigFacet;
import io.openlineage.client.OpenLineage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

public class OpenLineageEmitter
implements LineageEmitter {
    private static final String JAVA = "Java";
    private final ConnectorContext connectorContext;
    private final OpenLineageContext openLineageContext;
    private final String connectorName;
    private final DebeziumOpenLineageClient emitter;
    private final Map<String, String> config;
    private final DatasetNamespaceResolverFactory datasetNamespaceResolverFactory;

    public OpenLineageEmitter(ConnectorContext connectorContext, OpenLineageContext openLineageContext, DebeziumOpenLineageClient emitter, DatasetNamespaceResolverFactory datasetNamespaceResolverFactory) {
        this.connectorContext = connectorContext;
        this.openLineageContext = openLineageContext;
        this.connectorName = connectorContext.connectorName();
        this.emitter = emitter;
        this.config = connectorContext.config();
        this.datasetNamespaceResolverFactory = datasetNamespaceResolverFactory;
    }

    public void emit(DebeziumTaskState state) {
        this.emit(state, List.of(), null);
    }

    public void emit(DebeziumTaskState state, Throwable t) {
        this.emit(state, List.of(), t);
    }

    public void emit(DebeziumTaskState state, List<DatasetMetadata> datasetMetadata) {
        this.emit(state, datasetMetadata, null);
    }

    public void emit(DebeziumTaskState state, List<DatasetMetadata> datasetMetadata, Throwable t) {
        OpenLineage.Job job = new OpenLineageJobCreator(this.openLineageContext).create();
        List<OpenLineage.InputDataset> inputs = this.getInputDatasets(datasetMetadata);
        List<OpenLineage.OutputDataset> outputs = this.getOutputDatasets(datasetMetadata);
        OpenLineage.RunFacetsBuilder runFacetsBuilder = this.openLineageContext.getOpenLineage().newRunFacetsBuilder().processing_engine(this.openLineageContext.getOpenLineage().newProcessingEngineRunFacet(ProcessingEngineMetadata.debezium(this.connectorContext).version(), ProcessingEngineMetadata.debezium(this.connectorContext).name(), ProcessingEngineMetadata.debezium(this.connectorContext).openlineageAdapterVersion())).put("debezium_config", (OpenLineage.RunFacet)new DebeziumConfigFacet(this.emitter.getProducer(), this.config));
        this.addStackTrace(t, runFacetsBuilder);
        OpenLineage.RunEvent startEvent = this.openLineageContext.getOpenLineage().newRunEventBuilder().eventType(OpenLineageEmitter.getEventType(state)).eventTime(ZonedDateTime.now(ZoneOffset.UTC)).run(this.openLineageContext.getOpenLineage().newRun(this.openLineageContext.getRunUuid(), runFacetsBuilder.build())).inputs(inputs).outputs(outputs).job(job).build();
        this.emitter.emit(startEvent);
    }

    public void close() {
        this.emitter.close();
    }

    private void addStackTrace(Throwable t, OpenLineage.RunFacetsBuilder runFacetsBuilder) {
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            runFacetsBuilder.errorMessage(this.openLineageContext.getOpenLineage().newErrorMessageRunFacet(t.getMessage(), JAVA, sw.toString()));
        }
    }

    private List<OpenLineage.InputDataset> getInputDatasets(List<DatasetMetadata> datasetMetadata) {
        return datasetMetadata.stream().filter(dataset -> DatasetMetadata.DatasetKind.INPUT.equals((Object)dataset.kind())).map(this::mapToInputDataset).toList();
    }

    private List<OpenLineage.OutputDataset> getOutputDatasets(List<DatasetMetadata> datasetMetadata) {
        return datasetMetadata.stream().filter(dataset -> DatasetMetadata.DatasetKind.OUTPUT.equals((Object)dataset.kind())).map(this::mapToOutputDataset).toList();
    }

    private OpenLineage.OutputDataset mapToOutputDataset(DatasetMetadata outputDatasetMetadata) {
        List<OpenLineage.SchemaDatasetFacetFields> datasetFields = outputDatasetMetadata.fields().stream().map(this::buildSchemaDatasetFacetFields).toList();
        DatasetNamespaceResolver datasetNamespaceResolver = this.datasetNamespaceResolverFactory.create(outputDatasetMetadata.store(), this.connectorName);
        return this.openLineageContext.getOpenLineage().newOutputDatasetBuilder().namespace(datasetNamespaceResolver.resolve(this.config, this.connectorName)).name(outputDatasetMetadata.name()).facets(this.openLineageContext.getOpenLineage().newDatasetFacetsBuilder().schema(this.openLineageContext.getOpenLineage().newSchemaDatasetFacetBuilder().fields(datasetFields).build()).datasetType(this.openLineageContext.getOpenLineage().newDatasetTypeDatasetFacet(outputDatasetMetadata.type(), "")).build()).build();
    }

    private OpenLineage.SchemaDatasetFacetFields buildSchemaDatasetFacetFields(DatasetMetadata.FieldDefinition fieldDefinition) {
        if (fieldDefinition.fields() != null && !fieldDefinition.fields().isEmpty()) {
            List<OpenLineage.SchemaDatasetFacetFields> nestedFields = fieldDefinition.fields().stream().map(this::buildSchemaDatasetFacetFields).toList();
            return this.openLineageContext.getOpenLineage().newSchemaDatasetFacetFieldsBuilder().name(fieldDefinition.name()).type(fieldDefinition.typeName()).description(fieldDefinition.description()).fields(nestedFields).build();
        }
        return this.openLineageContext.getOpenLineage().newSchemaDatasetFacetFieldsBuilder().name(fieldDefinition.name()).type(fieldDefinition.typeName()).description(fieldDefinition.description()).build();
    }

    private OpenLineage.InputDataset mapToInputDataset(DatasetMetadata inputDatasetMetadata) {
        List<OpenLineage.SchemaDatasetFacetFields> datasetFields = inputDatasetMetadata.fields().stream().map(datasetMetadata -> this.openLineageContext.getOpenLineage().newSchemaDatasetFacetFieldsBuilder().name(datasetMetadata.name()).type(datasetMetadata.typeName()).description(datasetMetadata.description()).build()).toList();
        DatasetNamespaceResolver datasetNamespaceResolver = this.datasetNamespaceResolverFactory.create(inputDatasetMetadata.store(), this.connectorName);
        return this.openLineageContext.getOpenLineage().newInputDatasetBuilder().namespace(datasetNamespaceResolver.resolve(this.config, this.connectorName)).name(inputDatasetMetadata.name()).facets(this.openLineageContext.getOpenLineage().newDatasetFacetsBuilder().schema(this.openLineageContext.getOpenLineage().newSchemaDatasetFacetBuilder().fields(datasetFields).build()).datasetType(this.openLineageContext.getOpenLineage().newDatasetTypeDatasetFacet(inputDatasetMetadata.type(), "")).build()).build();
    }

    private static OpenLineage.RunEvent.EventType getEventType(DebeziumTaskState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case DebeziumTaskState.INITIAL -> OpenLineage.RunEvent.EventType.START;
            case DebeziumTaskState.RUNNING -> OpenLineage.RunEvent.EventType.RUNNING;
            case DebeziumTaskState.RESTARTING -> OpenLineage.RunEvent.EventType.FAIL;
            case DebeziumTaskState.STOPPED -> OpenLineage.RunEvent.EventType.COMPLETE;
        };
    }

    public OpenLineageContext getContext() {
        return this.openLineageContext;
    }
}

