/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.openlineage.dataset;

import io.debezium.openlineage.dataset.DatasetMetadata;
import io.debezium.openlineage.dataset.DatasetNamespaceResolver;
import io.debezium.openlineage.dataset.DatasetNamespaceResolverFactory;
import io.debezium.openlineage.dataset.DefaultDatabaseNamespaceResolver;
import io.debezium.openlineage.dataset.JdbcDatasetNamespaceResolver;
import io.debezium.openlineage.dataset.KafkaDatasetNamespaceResolver;
import io.debezium.openlineage.dataset.MongoDbDatasetNamespaceResolver;
import io.debezium.openlineage.dataset.PostgresDatasetNamespaceResolver;

public class DefaultDatasetNamespaceResolverFactory
implements DatasetNamespaceResolverFactory {
    private static final String MONGODB = "mongodb";
    private static final String POSTGRESQL = "postgresql";
    private static final String JDBC = "Jdbc";
    public static final String MONGODB_SINK = "mongodb-sink";

    @Override
    public DatasetNamespaceResolver create(DatasetMetadata.DataStore dataStore, String connectorName) {
        return switch (dataStore) {
            default -> throw new IncompatibleClassChangeError();
            case DatasetMetadata.DataStore.DATABASE -> DefaultDatasetNamespaceResolverFactory.resolveDatabase(connectorName);
            case DatasetMetadata.DataStore.KAFKA -> new KafkaDatasetNamespaceResolver();
        };
    }

    private static DatasetNamespaceResolver resolveDatabase(String connectorName) {
        return switch (connectorName) {
            case MONGODB, MONGODB_SINK -> new MongoDbDatasetNamespaceResolver();
            case POSTGRESQL -> new PostgresDatasetNamespaceResolver();
            case JDBC -> new JdbcDatasetNamespaceResolver();
            default -> new DefaultDatabaseNamespaceResolver();
        };
    }
}

