/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.openlineage.emitter;

import io.debezium.openlineage.ConnectorContext;
import io.debezium.openlineage.DebeziumOpenLineageConfiguration;
import io.openlineage.client.Clients;
import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClient;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumOpenLineageClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebeziumOpenLineageClient.class);
    private static final String OPEN_LINEAGE_PRODUCER_URI_FORMAT = "https://github.com/debezium/debezium/tree/%s/debezium-openlineage";
    private static final String NOT_AVAILABLE = "N/A";
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String MAIN_BRANCH_NAME = "main";
    private static final String VERSION_FORMAT = "v%s";
    private final ExecutorService emitterExecutor = Executors.newSingleThreadExecutor();
    private final OpenLineageClient openLineageClient;
    private final ConnectorContext connectorContext;

    public DebeziumOpenLineageClient(ConnectorContext connectorContext, DebeziumOpenLineageConfiguration config) {
        this.connectorContext = connectorContext;
        LOGGER.debug("Creating new openlineage client with config {}", (Object)config.config().path());
        this.openLineageClient = config.enabled() ? Clients.newClient(() -> List.of(Path.of(config.config().path(), new String[0]))) : null;
        LOGGER.debug("OpenLineage client v{} configured", (Object)this.getClientVersion());
    }

    public DebeziumOpenLineageClient(OpenLineageClient client, ConnectorContext connectorContext) {
        this.openLineageClient = client;
        this.connectorContext = connectorContext;
    }

    public void emit(OpenLineage.RunEvent event) {
        CompletableFuture.supplyAsync(() -> {
            try {
                this.openLineageClient.emit(event);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }, this.emitterExecutor).exceptionally(throwable -> {
            LOGGER.error("Failed to emit OpenLineage event: ", throwable);
            return null;
        });
    }

    public boolean isEnabled() {
        return this.openLineageClient != null;
    }

    public String getClientVersion() {
        Package pkg = OpenLineageClient.class.getPackage();
        if (pkg != null) {
            String version = pkg.getImplementationVersion();
            return version != null ? version : NOT_AVAILABLE;
        }
        return NOT_AVAILABLE;
    }

    public URI getProducer() {
        String gitTag = this.connectorContext.version().contains(SNAPSHOT) ? MAIN_BRANCH_NAME : String.format(VERSION_FORMAT, this.connectorContext.version());
        return URI.create(String.format(OPEN_LINEAGE_PRODUCER_URI_FORMAT, gitTag));
    }
}

