/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.performance.core;

import io.debezium.data.Envelope;
import io.debezium.transforms.Filter;
import io.debezium.util.Collect;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.Transformation;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

public class FilterSmtPerf {
    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    @Fork(value=1)
    @Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=3, time=2, timeUnit=TimeUnit.SECONDS)
    public void java(TransformState state) {
        state.nativeFilter.apply((ConnectRecord)state.create);
        state.nativeFilter.apply((ConnectRecord)state.create);
        state.nativeFilter.apply((ConnectRecord)state.delete);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    @Fork(value=1)
    @Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=3, time=2, timeUnit=TimeUnit.SECONDS)
    public void groovy(TransformState state) {
        state.groovyFilter.apply((ConnectRecord)state.create);
        state.groovyFilter.apply((ConnectRecord)state.create);
        state.groovyFilter.apply((ConnectRecord)state.delete);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    @Fork(value=1)
    @Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=3, time=2, timeUnit=TimeUnit.SECONDS)
    public void javascript(TransformState state) {
        state.jsFilter.apply((ConnectRecord)state.create);
        state.jsFilter.apply((ConnectRecord)state.create);
        state.jsFilter.apply((ConnectRecord)state.delete);
    }

    @State(value=Scope.Thread)
    public static class TransformState {
        public Transformation<SourceRecord> nativeFilter;
        public Transformation<SourceRecord> groovyFilter;
        public Transformation<SourceRecord> jsFilter;
        public SourceRecord delete;
        public SourceRecord create;

        @Setup(value=Level.Trial)
        public void doSetup() {
            Schema schema = SchemaBuilder.struct().name("dummyenv").field("op", Schema.STRING_SCHEMA).build();
            Struct deleteValue = new Struct(schema);
            deleteValue.put("op", (Object)"d");
            this.delete = new SourceRecord(new HashMap(), new HashMap(), "top1", Integer.valueOf(1), schema, (Object)this.delete);
            Struct createValue = new Struct(schema);
            createValue.put("op", (Object)"c");
            this.create = new SourceRecord(new HashMap(), new HashMap(), "top1", Integer.valueOf(1), schema, (Object)this.create);
            this.nativeFilter = new NativeFilter();
            this.nativeFilter.configure(new HashMap());
            this.groovyFilter = new Filter();
            this.groovyFilter.configure(Collect.hashMapOf((Object)"language", (Object)"groovy", (Object)"condition", (Object)"value.op == 'd'"));
            this.jsFilter = new Filter();
            this.jsFilter.configure(Collect.hashMapOf((Object)"language", (Object)"graal.js", (Object)"condition", (Object)"value.get('op') == 'd'"));
        }
    }

    private static class NativeFilter
    implements Transformation<SourceRecord> {
        private NativeFilter() {
        }

        public void configure(Map<String, ?> configs) {
        }

        public SourceRecord apply(SourceRecord record) {
            if (record.value() == null) {
                return record;
            }
            if (Envelope.Operation.DELETE.code().equals(((Struct)record.value()).getString("op"))) {
                return null;
            }
            return record;
        }

        public ConfigDef config() {
            return null;
        }

        public void close() {
        }
    }
}

