/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.performance.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.embedded.EmbeddedEngine;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.IoUtil;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.kafka.connect.source.SourceRecord;
import org.awaitility.Awaitility;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

public class EndToEndPerf {
    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    @Fork(value=1)
    @Warmup(iterations=0)
    @Measurement(iterations=1, time=1)
    public void capture(EndToEndState state) {
        ArrayList records = new ArrayList();
        while (records.size() < state.dmlEvents) {
            ArrayList temp = new ArrayList();
            state.consumedLines.drainTo(temp);
            records.addAll(temp);
        }
    }

    @State(value=Scope.Thread)
    public static class EndToEndState {
        private EmbeddedEngine engine;
        private ExecutorService executors;
        private BlockingQueue<SourceRecord> consumedLines;
        @Param(value={"1000", "5000", "10000"})
        public int dmlEvents;
        @Param(value={"legacy", "fast"})
        public String parser;
        @Param(value={"redo_log_catalog", "online_catalog"})
        public String miningStrategy;
        private static final String HOST = "localhost";
        private static final String USER = "c##dbzuser";
        private static final String PASSWORD = "dbz";
        private static final String DATABASE_CDB = "ORCLCDB";
        private static final String SERVER_NAME = "server1";
        private static final String SCHEMA_USER = "debezium";
        private static final String SCHEMA_USER_PASSWORD = "dbz";
        private static final String DATABASE = "ORCLPDB1";

        @Setup(value=Level.Iteration)
        public void doSetup() {
            this.consumedLines = new ArrayBlockingQueue<SourceRecord>(100);
            OracleConnection connection = this.getTestConnection();
            try {
                connection.execute(new String[]{"DROP TABLE debezium.test"});
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                connection.execute(new String[]{"CREATE TABLE debezium.test (id numeric(9,0) primary key, name varchar2(50))"});
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to create table", e);
            }
            this.delete("offsets.txt");
            this.delete("history.txt");
            Configuration connectorConfig = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.defaultConnectorConfig().with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.TEST")).with(OracleConnectorConfig.LOG_MINING_STRATEGY, (EnumeratedValue)OracleConnectorConfig.LogMiningStrategy.parse((String)this.miningStrategy))).with(OracleConnectorConfig.LOG_MINING_DML_PARSER, (EnumeratedValue)OracleConnectorConfig.LogMiningDmlParser.parse((String)this.parser))).build();
            Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.copy((Configuration)connectorConfig).with(EmbeddedEngine.ENGINE_NAME, "benchmark")).with(EmbeddedEngine.CONNECTOR_CLASS, OracleConnector.class)).with("offset.storage.file.filename", (Object)this.getPath("offsets.txt").toAbsolutePath())).with(EmbeddedEngine.OFFSET_FLUSH_INTERVAL_MS, 0)).build();
            Consumer<SourceRecord> recordArrivedListener = this::processRecord;
            this.engine = EmbeddedEngine.create().using(config).notifying(record -> {
                if (!this.engine.isRunning() || Thread.currentThread().isInterrupted()) {
                    return;
                }
                while (!this.consumedLines.offer((SourceRecord)record)) {
                    if (this.engine.isRunning() && !Thread.currentThread().isInterrupted()) continue;
                    return;
                }
                recordArrivedListener.accept((SourceRecord)record);
            }).using(this.getClass().getClassLoader()).build();
            this.executors = Executors.newFixedThreadPool(1);
            this.executors.execute((Runnable)this.engine);
            this.waitForStreamingToStart();
            try {
                for (int i = 0; i < this.dmlEvents; ++i) {
                    StringBuilder dml = new StringBuilder("INSERT INTO debezium.test (id, name) values (");
                    dml.append(i).append(",").append("'Test").append(i).append("')");
                    connection.executeWithoutCommitting(new String[]{dml.toString()});
                }
                connection.execute(new String[]{"COMMIT"});
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to insert data set", e);
            }
        }

        @TearDown(value=Level.Iteration)
        public void doCleanup() {
            block13: {
                try {
                    if (this.engine != null && this.engine.isRunning()) {
                        this.engine.stop();
                        try {
                            this.engine.await(60L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    if (this.executors != null) {
                        this.executors.shutdownNow();
                        try {
                            while (!this.executors.awaitTermination(60L, TimeUnit.SECONDS)) {
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    if (this.engine == null || !this.engine.isRunning()) break block13;
                    try {
                        while (!this.engine.await(60L, TimeUnit.SECONDS)) {
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                finally {
                    this.engine = null;
                    this.executors = null;
                }
            }
        }

        private JdbcConfiguration defaultJdbcConfig() {
            return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDefault(JdbcConfiguration.HOSTNAME, HOST)).withDefault(JdbcConfiguration.PORT, 1521)).withDefault(JdbcConfiguration.USER, USER)).withDefault(JdbcConfiguration.PASSWORD, "dbz")).withDefault(JdbcConfiguration.DATABASE, DATABASE_CDB)).build();
        }

        private JdbcConfiguration testJdbcConfig() {
            return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDefault(JdbcConfiguration.HOSTNAME, HOST)).withDefault(JdbcConfiguration.PORT, 1521)).withDefault(JdbcConfiguration.USER, SCHEMA_USER)).withDefault(JdbcConfiguration.PASSWORD, "dbz")).withDefault(JdbcConfiguration.DATABASE, DATABASE)).build();
        }

        private Configuration.Builder defaultConnectorConfig() {
            JdbcConfiguration jdbcConfiguration = this.defaultJdbcConfig();
            Configuration.Builder builder = Configuration.create();
            jdbcConfiguration.forEach((f, v) -> builder.with("database." + f, v));
            return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)builder.with(OracleConnectorConfig.SERVER_NAME, SERVER_NAME)).with(OracleConnectorConfig.PDB_NAME, DATABASE)).with(OracleConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(OracleConnectorConfig.CONNECTOR_ADAPTER, (EnumeratedValue)OracleConnectorConfig.ConnectorAdapter.LOG_MINER)).with(OracleConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)this.getPath("history.txt"));
        }

        private Configuration.Builder testConfig() {
            JdbcConfiguration jdbcConfiguration = this.testJdbcConfig();
            Configuration.Builder builder = Configuration.create();
            jdbcConfiguration.forEach((f, v) -> builder.with("database." + f, v));
            return builder;
        }

        private OracleConnection getTestConnection() {
            Configuration config = this.testConfig().build();
            Configuration jdbcConfig = config.subset("database.", true);
            OracleConnection connection = new OracleConnection(jdbcConfig, EndToEndPerf.class::getClassLoader);
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            String pdbName = new OracleConnectorConfig(config).getPdbName();
            if (pdbName != null) {
                connection.setSessionToPdb(pdbName);
            }
            return connection;
        }

        private void waitForStreamingToStart() {
            Awaitility.await().alias("Streaming was not started on time").pollInterval(100L, TimeUnit.MILLISECONDS).atMost(30L, TimeUnit.SECONDS).ignoreException(InstanceNotFoundException.class).until(() -> {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                try {
                    return (boolean)((Boolean)server.getAttribute(this.getName(), "Connected"));
                }
                catch (JMException jMException) {
                    return false;
                }
            });
        }

        private ObjectName getName() throws MalformedObjectNameException {
            return new ObjectName("debezium.oracle:type=connector-metrics,context=streaming,server=server1");
        }

        private Path getPath(String relativePath) {
            return Paths.get(this.resolveDataDir(), relativePath).toAbsolutePath();
        }

        private void delete(String relativePath) {
            Path history = this.getPath(relativePath).toAbsolutePath();
            if (history != null && this.inTestDataDir(history = history.toAbsolutePath())) {
                try {
                    IoUtil.delete((Path)history);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private boolean inTestDataDir(Path path) {
            Path target = FileSystems.getDefault().getPath(this.resolveDataDir(), new String[0]).toAbsolutePath();
            return path.toAbsolutePath().startsWith(target);
        }

        private String resolveDataDir() {
            String value = System.getProperty("dbz.test.data.dir");
            if (value != null && (value = value.trim()).length() > 0) {
                return value;
            }
            value = System.getenv("DBZ_TEST_DATA_DIR");
            if (value != null && (value = value.trim()).length() > 0) {
                return value;
            }
            return "target/data";
        }

        private void processRecord(SourceRecord record) {
            try {
                this.consumedLines.put(record);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed to insert record into queue", e);
            }
        }
    }
}

