/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.performance.engine;

import io.debezium.engine.DebeziumEngine;
import io.debezium.util.IoUtil;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Thread)
public abstract class AbstractDebeziumEnginePerf<R> {
    protected static final String OFFSET_FILE_NAME = "offsets.txt";
    private DebeziumEngine<R> engine;
    private ExecutorService executors;
    protected CountDownLatch finishLatch;
    @Param(value={"100000", "1000000"})
    public int recordCount;

    public abstract DebeziumEngine createEngine();

    @Setup(value=Level.Iteration)
    public void doSetup() throws InterruptedException {
        this.delete(OFFSET_FILE_NAME);
        this.finishLatch = new CountDownLatch(this.recordCount);
        this.engine = this.createEngine();
        this.executors = Executors.newFixedThreadPool(1);
        this.executors.execute((Runnable)this.engine);
    }

    @TearDown(value=Level.Iteration)
    public void doCleanup() throws IOException {
        try {
            if (this.engine != null) {
                this.engine.close();
            }
            if (this.executors != null) {
                this.executors.shutdown();
                try {
                    this.executors.awaitTermination(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    this.executors.shutdownNow();
                }
            }
        }
        finally {
            this.engine = null;
            this.executors = null;
        }
    }

    protected Consumer<R> getRecordConsumer() {
        return record -> {
            if (record != null) {
                this.finishLatch.countDown();
            }
        };
    }

    protected Path getPath(String relativePath) {
        return Paths.get(this.resolveDataDir(), relativePath).toAbsolutePath();
    }

    private void delete(String relativePath) {
        Path history = this.getPath(relativePath).toAbsolutePath();
        if (history != null && this.inTestDataDir(history = history.toAbsolutePath())) {
            try {
                IoUtil.delete((Path)history);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean inTestDataDir(Path path) {
        Path target = FileSystems.getDefault().getPath(this.resolveDataDir(), new String[0]).toAbsolutePath();
        return path.toAbsolutePath().startsWith(target);
    }

    private String resolveDataDir() {
        String value = System.getProperty("dbz.test.data.dir");
        if (value != null && (value = value.trim()).length() > 0) {
            return value;
        }
        value = System.getenv("DBZ_TEST_DATA_DIR");
        if (value != null && (value = value.trim()).length() > 0) {
            return value;
        }
        return "/tmp";
    }
}

