/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.performance.engine;

import io.debezium.config.Configuration;
import io.debezium.embedded.EmbeddedEngineConfig;
import io.debezium.embedded.async.AsyncEngineConfig;
import io.debezium.embedded.async.ConvertingAsyncEngineBuilderFactory;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.format.Json;
import io.debezium.engine.format.KeyValueChangeEventFormat;
import io.debezium.performance.engine.AbstractDebeziumEnginePerf;
import io.debezium.performance.engine.connector.PreComputedRecordsSourceConnector;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

public class DebeziumConvertingEnginePerf {
    protected static final KeyValueChangeEventFormat KV_EVENT_FORMAT = KeyValueChangeEventFormat.of(Json.class, Json.class);

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    @Fork(value=1)
    @Warmup(iterations=1)
    @Measurement(iterations=1, time=1)
    public void processRecordsAsyncEngine(AsyncEnginePerfTest test) throws InterruptedException {
        test.finishLatch.await();
    }

    @State(value=Scope.Thread)
    public static class AsyncEnginePerfTest
    extends AbstractDebeziumEnginePerf {
        @Param(value={"1", "2", "4", "8", "16"})
        public int threadCount;
        @Param(value={"ORDERED", "UNORDERED"})
        public String processingOrder;

        @Override
        public DebeziumEngine createEngine() {
            Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(EmbeddedEngineConfig.ENGINE_NAME, "async-engine")).with(EmbeddedEngineConfig.CONNECTOR_CLASS, PreComputedRecordsSourceConnector.class)).with("offset.storage.file.filename", (Object)this.getPath("offsets.txt").toAbsolutePath())).with(EmbeddedEngineConfig.OFFSET_FLUSH_INTERVAL_MS, 3600000)).with(AsyncEngineConfig.RECORD_PROCESSING_SHUTDOWN_TIMEOUT_MS, 100)).with(AsyncEngineConfig.TASK_MANAGEMENT_TIMEOUT_MS, 100)).with(AsyncEngineConfig.RECORD_PROCESSING_THREADS, this.threadCount)).with(AsyncEngineConfig.RECORD_PROCESSING_ORDER, this.processingOrder)).build();
            return new ConvertingAsyncEngineBuilderFactory().builder(KV_EVENT_FORMAT).using(config.asProperties()).notifying(this.getRecordConsumer()).using(this.getClass().getClassLoader()).build();
        }
    }
}

