/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded.async;

import io.debezium.config.Field;
import io.debezium.embedded.EmbeddedEngineConfig;

public interface AsyncEngineConfig
extends EmbeddedEngineConfig {
    public static final int AVAILABLE_CORES = Runtime.getRuntime().availableProcessors();
    public static final Field RECORD_PROCESSING_THREADS = Field.create((String)"record.processing.threads").withDescription("The number of threads to be used for processing CDC records. If you want to use all available threads, you can use 'AVAILABLE_CORES' placeholder. If the number of threads is not specified, the threads will be created as needed, using Java 'Executors.newCachedThreadPool()' executor service.").withDefault("");
    public static final Field RECORD_PROCESSING_SHUTDOWN_TIMEOUT_MS = Field.create((String)"record.processing.shutdown.timeout.ms").withDescription("Maximum time in milliseconds to wait for processing submitted records when task shutdown is called. The default is 10 seconds (10000 ms).").withDefault(1000L).withValidation(new Field.Validator[]{Field::isPositiveInteger});
    public static final Field RECORD_PROCESSING_ORDER = Field.create((String)"record.processing.order").withDescription("Determines how the records should be produced. 'ORDERED' (the default) means sequential processing, i.e. that the records are produced in the same order as they were obtained from the database. 'UNORDERED' means non-sequential processing, i.e. the records can be produced in a different order than the original one. Non-sequential approach gives better throughput, as the records are produced immediately once the SMTs and serialization of the message is done, without waiting of other records. This option doesn't have any effect when ChangeConsumer is provided to the engine.").withDefault("ORDERED");
    public static final Field RECORD_PROCESSING_WITH_SERIAL_CONSUMER = Field.create((String)"record.processing.with.serial.consumer").withDescription("Specifies whether the default ChangeConsumer should be created from provided Consumer, resulting in serial Consumer processing. This option has no effect if the ChangeConsumer is already provided to the engine via configuration.").withDefault(false).withValidation(new Field.Validator[]{Field::isBoolean});
    public static final Field TASK_MANAGEMENT_TIMEOUT_MS = Field.createInternal((String)"task.management.timeout.ms").withDescription("Time to wait for task's lifecycle management operations (starting and stopping), given in milliseconds. Defaults to 3 minutes (180_000 ms).").withDefault(180000L).withValidation(new Field.Validator[]{Field::isPositiveInteger});
    public static final Field.Set ALL_FIELDS = EmbeddedEngineConfig.ALL_FIELDS.with(new Field[]{RECORD_PROCESSING_SHUTDOWN_TIMEOUT_MS, RECORD_PROCESSING_THREADS, RECORD_PROCESSING_ORDER, RECORD_PROCESSING_WITH_SERIAL_CONSUMER, TASK_MANAGEMENT_TIMEOUT_MS});
}

