/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded.async;

import io.debezium.embedded.Transformations;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.kafka.connect.source.SourceRecord;

public class ProcessingCallables {

    public static class TransformConvertConsumeRecord<R>
    implements Callable<Void> {
        private final SourceRecord record;
        private final Transformations transformations;
        private final Function<SourceRecord, R> serializer;
        private final Consumer<R> consumer;

        TransformConvertConsumeRecord(SourceRecord record, Transformations transformations, Function<SourceRecord, R> serializer, Consumer<R> consumer) {
            this.record = record;
            this.transformations = transformations;
            this.serializer = serializer;
            this.consumer = consumer;
        }

        @Override
        public Void call() {
            SourceRecord transformedRecord = this.transformations.transform(this.record);
            if (transformedRecord != null) {
                this.consumer.accept(this.serializer.apply(transformedRecord));
            }
            return null;
        }
    }

    public static class TransformAndConvertRecord<R>
    implements Callable<R> {
        private final SourceRecord record;
        private final Transformations transformations;
        private final Function<SourceRecord, R> converter;

        TransformAndConvertRecord(SourceRecord record, Transformations transformations, Function<SourceRecord, R> converter) {
            this.record = record;
            this.transformations = transformations;
            this.converter = converter;
        }

        @Override
        public R call() {
            SourceRecord transformedRecord = this.transformations.transform(this.record);
            return transformedRecord != null ? (R)this.converter.apply(transformedRecord) : null;
        }
    }

    public static class TransformRecord
    implements Callable<SourceRecord> {
        private final SourceRecord record;
        private final Transformations transformations;

        TransformRecord(SourceRecord record, Transformations transformations) {
            this.record = record;
            this.transformations = transformations;
        }

        @Override
        public SourceRecord call() {
            SourceRecord transformedRecord = this.transformations.transform(this.record);
            return transformedRecord != null ? transformedRecord : null;
        }
    }

    public static class TransformAndConsumeRecord
    implements Callable<Void> {
        private final SourceRecord record;
        private final Transformations transformations;
        private final Consumer<SourceRecord> consumer;

        TransformAndConsumeRecord(SourceRecord record, Transformations transformations, Consumer<SourceRecord> consumer) {
            this.record = record;
            this.transformations = transformations;
            this.consumer = consumer;
        }

        @Override
        public Void call() {
            SourceRecord transformedRecord = this.transformations.transform(this.record);
            if (transformedRecord != null) {
                this.consumer.accept(transformedRecord);
            }
            return null;
        }
    }
}

