/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.embedded.StopConnectorException;
import io.debezium.embedded.spi.OffsetCommitPolicy;
import io.debezium.util.Clock;
import io.debezium.util.VariableLatch;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.apache.kafka.connect.source.SourceTaskContext;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.FileOffsetBackingStore;
import org.apache.kafka.connect.storage.KafkaOffsetBackingStore;
import org.apache.kafka.connect.storage.OffsetBackingStore;
import org.apache.kafka.connect.storage.OffsetStorageReader;
import org.apache.kafka.connect.storage.OffsetStorageReaderImpl;
import org.apache.kafka.connect.storage.OffsetStorageWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class EmbeddedEngine
implements Runnable {
    public static final Field ENGINE_NAME = Field.create((String)"name").withDescription("Unique name for this connector instance.").withValidation(new Field.Validator[]{Field::isRequired});
    public static final Field CONNECTOR_CLASS = Field.create((String)"connector.class").withDescription("The Java class for the connector").withValidation(new Field.Validator[]{Field::isRequired});
    public static final Field OFFSET_STORAGE = Field.create((String)"offset.storage").withDescription("The Java class that implements the `OffsetBackingStore` interface, used to periodically store offsets so that, upon restart, the connector can resume where it last left off.").withDefault(FileOffsetBackingStore.class.getName());
    public static final Field OFFSET_STORAGE_FILE_FILENAME = Field.create((String)"offset.storage.file.filename").withDescription("The file where offsets are to be stored. Required when 'offset.storage' is set to the " + FileOffsetBackingStore.class.getName() + " class.").withDefault("");
    public static final Field OFFSET_STORAGE_KAFKA_TOPIC = Field.create((String)"offset.storage.topic").withDescription("The name of the Kafka topic where offsets are to be stored. Required with other properties when 'offset.storage' is set to the " + KafkaOffsetBackingStore.class.getName() + " class.").withDefault("");
    public static final Field OFFSET_STORAGE_KAFKA_PARTITIONS = Field.create((String)"offset.storage.partitions").withType(ConfigDef.Type.INT).withDescription("The number of partitions used when creating the offset storage topic. Required with other properties when 'offset.storage' is set to the " + KafkaOffsetBackingStore.class.getName() + " class.");
    public static final Field OFFSET_STORAGE_KAFKA_REPLICATION_FACTOR = Field.create((String)"offset.storage.replication.factor").withType(ConfigDef.Type.SHORT).withDescription("Replication factor used when creating the offset storage topic. Required with other properties when 'offset.storage' is set to the " + KafkaOffsetBackingStore.class.getName() + " class.");
    public static final Field OFFSET_FLUSH_INTERVAL_MS = Field.create((String)"offset.flush.interval.ms").withDescription("Interval at which to try committing offsets. The default is 1 minute.").withDefault(60000L).withValidation(new Field.Validator[]{Field::isNonNegativeInteger});
    public static final Field OFFSET_COMMIT_TIMEOUT_MS = Field.create((String)"offset.flush.timeout.ms").withDescription("Maximum number of milliseconds to wait for records to flush and partition offset data to be committed to offset storage before cancelling the process and restoring the offset data to be committed in a future attempt.").withDefault(5000L).withValidation(new Field.Validator[]{Field::isPositiveInteger});
    public static final Field OFFSET_COMMIT_POLICY = Field.create((String)"offset.commit.policy").withDescription("The fully-qualified class name of the commit policy type. This class must implement the interface " + OffsetCommitPolicy.class.getName() + ". The default is a periodic commity policy based upon time intervals.").withDefault(OffsetCommitPolicy.PeriodicCommitOffsetPolicy.class.getName()).withValidation(new Field.Validator[]{Field::isClassName});
    protected static final Field INTERNAL_KEY_CONVERTER_CLASS = Field.create((String)"internal.key.converter").withDescription("The Converter class that should be used to serialize and deserialize key data for offsets.").withDefault(JsonConverter.class.getName());
    protected static final Field INTERNAL_VALUE_CONVERTER_CLASS = Field.create((String)"internal.value.converter").withDescription("The Converter class that should be used to serialize and deserialize value data for offsets.").withDefault(JsonConverter.class.getName());
    public static final Field.Set CONNECTOR_FIELDS = Field.setOf((Field[])new Field[]{ENGINE_NAME, CONNECTOR_CLASS});
    protected static final Field.Set ALL_FIELDS = CONNECTOR_FIELDS.with(new Field[]{OFFSET_STORAGE, OFFSET_STORAGE_FILE_FILENAME, OFFSET_FLUSH_INTERVAL_MS, OFFSET_COMMIT_TIMEOUT_MS, INTERNAL_KEY_CONVERTER_CLASS, INTERNAL_VALUE_CONVERTER_CLASS});
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Configuration config;
    private final Clock clock;
    private final ClassLoader classLoader;
    private final Consumer<SourceRecord> consumer;
    private final CompletionCallback completionCallback;
    private final ConnectorCallback connectorCallback;
    private final AtomicReference<Thread> runningThread = new AtomicReference();
    private final VariableLatch latch = new VariableLatch(0);
    private final Converter keyConverter;
    private final Converter valueConverter;
    private final WorkerConfig workerConfig;
    private final CompletionResult completionResult;
    private long recordsSinceLastCommit = 0L;
    private long timeOfLastCommitMillis = 0L;
    private OffsetCommitPolicy offsetCommitPolicy;

    public static Builder create() {
        return new Builder(){
            private Configuration config;
            private Consumer<SourceRecord> consumer;
            private ClassLoader classLoader;
            private Clock clock;
            private CompletionCallback completionCallback;
            private ConnectorCallback connectorCallback;
            private OffsetCommitPolicy offsetCommitPolicy = null;

            @Override
            public Builder using(Configuration config) {
                this.config = config;
                return this;
            }

            @Override
            public Builder using(ClassLoader classLoader) {
                this.classLoader = classLoader;
                return this;
            }

            @Override
            public Builder using(Clock clock) {
                this.clock = clock;
                return this;
            }

            @Override
            public Builder using(CompletionCallback completionCallback) {
                this.completionCallback = completionCallback;
                return this;
            }

            @Override
            public Builder using(ConnectorCallback connectorCallback) {
                this.connectorCallback = connectorCallback;
                return this;
            }

            @Override
            public Builder using(OffsetCommitPolicy offsetCommitPolicy) {
                this.offsetCommitPolicy = offsetCommitPolicy;
                return this;
            }

            @Override
            public Builder notifying(Consumer<SourceRecord> consumer) {
                this.consumer = consumer;
                return this;
            }

            @Override
            public EmbeddedEngine build() {
                if (this.classLoader == null) {
                    this.classLoader = this.getClass().getClassLoader();
                }
                if (this.clock == null) {
                    this.clock = Clock.system();
                }
                Objects.requireNonNull(this.config, "A connector configuration must be specified.");
                Objects.requireNonNull(this.consumer, "A connector consumer must be specified.");
                return new EmbeddedEngine(this.config, this.classLoader, this.clock, this.consumer, this.completionCallback, this.connectorCallback, this.offsetCommitPolicy);
            }
        };
    }

    private EmbeddedEngine(Configuration config, ClassLoader classLoader, Clock clock, Consumer<SourceRecord> consumer, CompletionCallback completionCallback, ConnectorCallback connectorCallback, OffsetCommitPolicy offsetCommitPolicy) {
        this.config = config;
        this.consumer = consumer;
        this.classLoader = classLoader;
        this.clock = clock;
        this.completionCallback = completionCallback != null ? completionCallback : (success, msg, error) -> {
            if (!success) {
                this.logger.error(msg, error);
            }
        };
        this.connectorCallback = connectorCallback;
        this.completionResult = new CompletionResult();
        this.offsetCommitPolicy = offsetCommitPolicy;
        assert (this.config != null);
        assert (this.consumer != null);
        assert (this.classLoader != null);
        assert (this.clock != null);
        this.keyConverter = (Converter)config.getInstance(INTERNAL_KEY_CONVERTER_CLASS, Converter.class, () -> this.classLoader);
        this.keyConverter.configure(config.subset(INTERNAL_KEY_CONVERTER_CLASS.name() + ".", true).asMap(), true);
        this.valueConverter = (Converter)config.getInstance(INTERNAL_VALUE_CONVERTER_CLASS, Converter.class, () -> this.classLoader);
        Configuration valueConverterConfig = config;
        if (this.valueConverter instanceof JsonConverter) {
            valueConverterConfig = ((Configuration.Builder)config.edit().with(INTERNAL_VALUE_CONVERTER_CLASS + ".schemas.enable", false)).build();
        }
        this.valueConverter.configure(valueConverterConfig.subset(INTERNAL_VALUE_CONVERTER_CLASS.name() + ".", true).asMap(), false);
        Map embeddedConfig = config.asMap(ALL_FIELDS);
        embeddedConfig.put("key.converter", JsonConverter.class.getName());
        embeddedConfig.put("value.converter", JsonConverter.class.getName());
        this.workerConfig = new EmbeddedConfig(embeddedConfig);
    }

    public boolean isRunning() {
        return this.runningThread.get() != null;
    }

    private void fail(String msg) {
        this.fail(msg, null);
    }

    private void fail(String msg, Throwable error) {
        if (this.completionResult.hasError()) {
            this.logger.error(msg, error);
            return;
        }
        this.completionResult.handle(false, msg, error);
    }

    private void succeed(String msg) {
        this.completionResult.handle(true, msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (!this.runningThread.compareAndSet(null, Thread.currentThread())) return;
        String engineName = this.config.getString(ENGINE_NAME);
        String connectorClassName = this.config.getString(CONNECTOR_CLASS);
        Optional<ConnectorCallback> connectorCallback = Optional.ofNullable(this.connectorCallback);
        this.latch.countUp();
        try {
            if (!this.config.validateAndRecord((Iterable)CONNECTOR_FIELDS, arg_0 -> ((Logger)this.logger).error(arg_0))) {
                this.fail("Failed to start connector with invalid configuration (see logs for actual errors)");
                return;
            }
            SourceConnector connector = null;
            try {
                Class<?> connectorClass = this.classLoader.loadClass(connectorClassName);
                connector = (SourceConnector)connectorClass.newInstance();
            }
            catch (Throwable t) {
                this.fail("Unable to instantiate connector class '" + connectorClassName + "'", t);
                this.latch.countDown();
                this.runningThread.set(null);
                this.completionCallback.handle(this.completionResult.success(), this.completionResult.message(), this.completionResult.error());
                return;
            }
            String offsetStoreClassName = this.config.getString(OFFSET_STORAGE);
            OffsetBackingStore offsetStore = null;
            try {
                Class<?> offsetStoreClass = this.classLoader.loadClass(offsetStoreClassName);
                offsetStore = (OffsetBackingStore)offsetStoreClass.newInstance();
            }
            catch (Throwable t) {
                this.fail("Unable to instantiate OffsetBackingStore class '" + offsetStoreClassName + "'", t);
                this.latch.countDown();
                this.runningThread.set(null);
                this.completionCallback.handle(this.completionResult.success(), this.completionResult.message(), this.completionResult.error());
                return;
            }
            try {
                offsetStore.configure(this.workerConfig);
                offsetStore.start();
            }
            catch (Throwable t) {
                this.fail("Unable to configure and start the '" + offsetStoreClassName + "' offset backing store", t);
                this.latch.countDown();
                this.runningThread.set(null);
                this.completionCallback.handle(this.completionResult.success(), this.completionResult.message(), this.completionResult.error());
                return;
            }
            if (this.offsetCommitPolicy == null) {
                this.offsetCommitPolicy = (OffsetCommitPolicy)this.config.getInstance(OFFSET_COMMIT_POLICY, OffsetCommitPolicy.class, this.config);
            }
            ConnectorContext context = new ConnectorContext(){

                public void requestTaskReconfiguration() {
                }

                public void raiseError(Exception e) {
                    EmbeddedEngine.this.fail(e.getMessage(), e);
                }
            };
            connector.initialize(context);
            OffsetStorageWriter offsetWriter = new OffsetStorageWriter(offsetStore, engineName, this.keyConverter, this.valueConverter);
            OffsetStorageReaderImpl offsetReader = new OffsetStorageReaderImpl(offsetStore, engineName, this.keyConverter, this.valueConverter);
            long commitTimeoutMs = this.config.getLong(OFFSET_COMMIT_TIMEOUT_MS);
            try {
                connector.start(this.config.asMap());
                connectorCallback.ifPresent(ConnectorCallback::connectorStarted);
                List taskConfigs = connector.taskConfigs(1);
                Class taskClass = connector.taskClass();
                SourceTask task = null;
                try {
                    task = (SourceTask)taskClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException t) {
                    this.fail("Unable to instantiate connector's task class '" + taskClass.getName() + "'", t);
                    try {
                        offsetStore.stop();
                    }
                    catch (Throwable t2) {
                        this.fail("Error while trying to stop the offset store", t2);
                    }
                    finally {
                        try {
                            connector.stop();
                            connectorCallback.ifPresent(ConnectorCallback::connectorStopped);
                        }
                        catch (Throwable t3) {
                            this.fail("Error while trying to stop connector class '" + connectorClassName + "'", t3);
                        }
                    }
                    this.latch.countDown();
                    this.runningThread.set(null);
                    this.completionCallback.handle(this.completionResult.success(), this.completionResult.message(), this.completionResult.error());
                    return;
                }
                try {
                    SourceTaskContext taskContext = () -> EmbeddedEngine.lambda$run$3((OffsetStorageReader)offsetReader);
                    task.initialize(taskContext);
                    task.start((Map)taskConfigs.get(0));
                    connectorCallback.ifPresent(ConnectorCallback::taskStarted);
                }
                catch (Throwable t) {
                    Configuration config = Configuration.from((Map)((Map)taskConfigs.get(0))).withMaskedPasswords();
                    String msg = "Unable to initialize and start connector's task class '" + taskClass.getName() + "' with config: " + config;
                    this.fail(msg, t);
                    try {
                        offsetStore.stop();
                    }
                    catch (Throwable t4) {
                        this.fail("Error while trying to stop the offset store", t4);
                    }
                    finally {
                        try {
                            connector.stop();
                            connectorCallback.ifPresent(ConnectorCallback::connectorStopped);
                        }
                        catch (Throwable t5) {
                            this.fail("Error while trying to stop connector class '" + connectorClassName + "'", t5);
                        }
                    }
                    this.latch.countDown();
                    this.runningThread.set(null);
                    this.completionCallback.handle(this.completionResult.success(), this.completionResult.message(), this.completionResult.error());
                    return;
                }
                this.recordsSinceLastCommit = 0L;
                Throwable handlerError = null;
                try {
                    this.timeOfLastCommitMillis = this.clock.currentTimeInMillis();
                    boolean keepProcessing = true;
                    List changeRecords = null;
                    while (this.runningThread.get() != null) {
                        if (handlerError != null) return;
                        if (!keepProcessing) return;
                        try {
                            try {
                                this.logger.debug("Embedded engine is polling task for records on thread " + this.runningThread.get());
                                changeRecords = task.poll();
                                this.logger.debug("Embedded engine returned from polling task for records");
                            }
                            catch (InterruptedException e) {
                                this.logger.debug("Embedded engine interrupted on thread " + this.runningThread.get() + " while polling the task for records");
                                Thread.interrupted();
                                this.maybeFlush(offsetWriter, this.offsetCommitPolicy, commitTimeoutMs, task);
                                return;
                            }
                            try {
                                Iterator e;
                                if (changeRecords != null && !changeRecords.isEmpty()) {
                                    this.logger.debug("Received {} records from the task", (Object)changeRecords.size());
                                    e = changeRecords.iterator();
                                } else {
                                    this.logger.debug("Received no records from the task");
                                    continue;
                                }
                                while (e.hasNext()) {
                                    SourceRecord record = (SourceRecord)e.next();
                                    try {
                                        this.consumer.accept(record);
                                        task.commitRecord(record);
                                    }
                                    catch (StopConnectorException e2) {
                                        keepProcessing = false;
                                        offsetWriter.offset(record.sourcePartition(), record.sourceOffset());
                                        ++this.recordsSinceLastCommit;
                                        break;
                                    }
                                    catch (Throwable t) {
                                        handlerError = t;
                                        break;
                                    }
                                    offsetWriter.offset(record.sourcePartition(), record.sourceOffset());
                                    ++this.recordsSinceLastCommit;
                                }
                                this.maybeFlush(offsetWriter, this.offsetCommitPolicy, commitTimeoutMs, task);
                            }
                            catch (Throwable t) {
                                if (handlerError == null) {
                                    handlerError = t;
                                }
                                this.maybeFlush(offsetWriter, this.offsetCommitPolicy, commitTimeoutMs, task);
                                return;
                            }
                        }
                        finally {
                            this.maybeFlush(offsetWriter, this.offsetCommitPolicy, commitTimeoutMs, task);
                        }
                    }
                    return;
                }
                finally {
                    if (handlerError != null) {
                        this.fail("Stopping connector after error in the application's handler method: " + handlerError.getMessage(), handlerError);
                    }
                    try {
                        this.logger.debug("Stopping the task and engine");
                        task.stop();
                        connectorCallback.ifPresent(ConnectorCallback::taskStopped);
                        this.commitOffsets(offsetWriter, commitTimeoutMs, task);
                        if (handlerError == null) {
                            this.succeed("Connector '" + connectorClassName + "' completed normally.");
                        }
                    }
                    catch (Throwable t) {
                        this.fail("Error while trying to stop the task and commit the offsets", t);
                    }
                }
            }
            catch (Throwable t) {
                this.fail("Error while trying to run connector class '" + connectorClassName + "'", t);
                return;
            }
            finally {
                try {
                    offsetStore.stop();
                }
                catch (Throwable t) {
                    this.fail("Error while trying to stop the offset store", t);
                }
                finally {
                    try {
                        connector.stop();
                        connectorCallback.ifPresent(ConnectorCallback::connectorStopped);
                    }
                    catch (Throwable t) {
                        this.fail("Error while trying to stop connector class '" + connectorClassName + "'", t);
                    }
                }
            }
        }
        finally {
            this.latch.countDown();
            this.runningThread.set(null);
            this.completionCallback.handle(this.completionResult.success(), this.completionResult.message(), this.completionResult.error());
        }
    }

    protected void maybeFlush(OffsetStorageWriter offsetWriter, OffsetCommitPolicy policy, long commitTimeoutMs, SourceTask task) {
        long timeSinceLastCommitMillis = this.clock.currentTimeInMillis() - this.timeOfLastCommitMillis;
        if (policy.performCommit(this.recordsSinceLastCommit, Duration.ofMillis(timeSinceLastCommitMillis))) {
            this.commitOffsets(offsetWriter, commitTimeoutMs, task);
        }
    }

    protected void commitOffsets(OffsetStorageWriter offsetWriter, long commitTimeoutMs, SourceTask task) {
        long started = this.clock.currentTimeInMillis();
        long timeout = started + commitTimeoutMs;
        if (!offsetWriter.beginFlush()) {
            return;
        }
        Future flush = offsetWriter.doFlush(this::completedFlush);
        if (flush == null) {
            return;
        }
        try {
            flush.get(Math.max(timeout - this.clock.currentTimeInMillis(), 0L), TimeUnit.MILLISECONDS);
            task.commit();
            this.recordsSinceLastCommit = 0L;
            this.timeOfLastCommitMillis = this.clock.currentTimeInMillis();
        }
        catch (InterruptedException e) {
            this.logger.warn("Flush of {} offsets interrupted, cancelling", (Object)this);
            offsetWriter.cancelFlush();
        }
        catch (ExecutionException e) {
            this.logger.error("Flush of {} offsets threw an unexpected exception: ", (Object)this, (Object)e);
            offsetWriter.cancelFlush();
        }
        catch (TimeoutException e) {
            this.logger.error("Timed out waiting to flush {} offsets to storage", (Object)this);
            offsetWriter.cancelFlush();
        }
    }

    protected void completedFlush(Throwable error, Void result) {
        if (error != null) {
            this.logger.error("Failed to flush {} offsets to storage: ", (Object)this, (Object)error);
        } else {
            this.logger.trace("Finished flushing {} offsets to storage", (Object)this);
        }
    }

    public boolean stop() {
        this.logger.debug("Stopping the embedded engine");
        Thread thread = this.runningThread.getAndSet(null);
        if (thread != null) {
            this.logger.debug("Interruping the embedded engine's thread " + thread + " (already interrupted: " + thread.isInterrupted() + ")");
            thread.interrupt();
            return true;
        }
        return false;
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }

    public String toString() {
        return "EmbeddedConnector{id=" + this.config.getString(ENGINE_NAME) + '}';
    }

    private static /* synthetic */ OffsetStorageReader lambda$run$3(OffsetStorageReader offsetReader) {
        return offsetReader;
    }

    protected static class EmbeddedConfig
    extends WorkerConfig {
        private static final ConfigDef CONFIG;

        protected EmbeddedConfig(Map<String, String> props) {
            super(CONFIG, props);
        }

        static {
            ConfigDef config = EmbeddedConfig.baseConfigDef();
            Field.group((ConfigDef)config, (String)"file", (Field[])new Field[]{OFFSET_STORAGE_FILE_FILENAME});
            Field.group((ConfigDef)config, (String)"kafka", (Field[])new Field[]{OFFSET_STORAGE_KAFKA_TOPIC});
            Field.group((ConfigDef)config, (String)"kafka", (Field[])new Field[]{OFFSET_STORAGE_KAFKA_PARTITIONS});
            Field.group((ConfigDef)config, (String)"kafka", (Field[])new Field[]{OFFSET_STORAGE_KAFKA_REPLICATION_FACTOR});
            CONFIG = config;
        }
    }

    public static interface Builder {
        public Builder notifying(Consumer<SourceRecord> var1);

        public Builder using(Configuration var1);

        public Builder using(ClassLoader var1);

        public Builder using(Clock var1);

        public Builder using(CompletionCallback var1);

        public Builder using(ConnectorCallback var1);

        public Builder using(OffsetCommitPolicy var1);

        public EmbeddedEngine build();
    }

    public static class CompletionResult
    implements CompletionCallback {
        private final CompletionCallback delegate;
        private final CountDownLatch completed = new CountDownLatch(1);
        private boolean success;
        private String message;
        private Throwable error;

        public CompletionResult() {
            this(null);
        }

        public CompletionResult(CompletionCallback delegate) {
            this.delegate = delegate;
        }

        @Override
        public void handle(boolean success, String message, Throwable error) {
            this.success = success;
            this.message = message;
            this.error = error;
            this.completed.countDown();
            if (this.delegate != null) {
                this.delegate.handle(success, message, error);
            }
        }

        public void await() throws InterruptedException {
            this.completed.await();
        }

        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.completed.await(timeout, unit);
        }

        public boolean hasCompleted() {
            return this.completed.getCount() == 0L;
        }

        public boolean success() {
            return this.success;
        }

        public String message() {
            return this.message;
        }

        public Throwable error() {
            return this.error;
        }

        public boolean hasError() {
            return this.error != null;
        }
    }

    public static interface ConnectorCallback {
        default public void connectorStarted() {
        }

        default public void connectorStopped() {
        }

        default public void taskStarted() {
        }

        default public void taskStopped() {
        }
    }

    public static interface CompletionCallback {
        public void handle(boolean var1, String var2, Throwable var3);
    }
}

