/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.antlr;

import io.debezium.annotation.Immutable;
import io.debezium.annotation.ThreadSafe;
import io.debezium.antlr.AntlrDdlParser;
import io.debezium.relational.ddl.DataType;
import io.debezium.relational.ddl.DataTypeBuilder;
import io.debezium.text.ParsingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;

@ThreadSafe
@Immutable
public class DataTypeResolver {
    private final Map<String, List<DataTypeEntry>> contextDataTypesMap;

    private DataTypeResolver(Map<String, List<DataTypeEntry>> contextDataTypesMap) {
        this.contextDataTypesMap = Collections.unmodifiableMap(contextDataTypesMap);
    }

    public DataType resolveDataType(ParserRuleContext dataTypeContext) {
        DataType dataType = null;
        int selectedTypePriority = -1;
        for (DataTypeEntry dataTypeEntry : this.contextDataTypesMap.get(dataTypeContext.getClass().getCanonicalName())) {
            int dataTypePriority = dataTypeEntry.getDbmsDataTypeTokenIdentifiers().length;
            if (dataTypePriority <= selectedTypePriority) continue;
            DataTypeBuilder dataTypeBuilder = new DataTypeBuilder();
            boolean correctDataType = true;
            for (Integer mainTokenIdentifier : dataTypeEntry.getDbmsDataTypeTokenIdentifiers()) {
                TerminalNode token = dataTypeContext.getToken(mainTokenIdentifier.intValue(), 0);
                if (!correctDataType) continue;
                if (token == null) {
                    correctDataType = false;
                    continue;
                }
                dataTypeBuilder.addToName(token.getText());
            }
            if (!correctDataType) continue;
            dataType = this.buildDataType(dataTypeContext, dataTypeEntry, dataTypeBuilder);
            selectedTypePriority = dataTypePriority;
        }
        if (dataType == null) {
            throw new ParsingException(null, "Unrecognized dataType for " + AntlrDdlParser.getText(dataTypeContext));
        }
        return dataType;
    }

    private DataType buildDataType(ParserRuleContext dataTypeContext, DataTypeEntry dataTypeEntry, DataTypeBuilder dataTypeBuilder) {
        this.addOptionalSuffixToName(dataTypeContext, dataTypeEntry, dataTypeBuilder);
        dataTypeBuilder.jdbcType(dataTypeEntry.getJdbcDataType());
        dataTypeBuilder.length((long)dataTypeEntry.getDefaultLength());
        dataTypeBuilder.scale(dataTypeEntry.getDefaultScale());
        return dataTypeBuilder.create();
    }

    private void addOptionalSuffixToName(ParserRuleContext dataTypeContext, DataTypeEntry dataTypeEntry, DataTypeBuilder dataTypeBuilder) {
        if (dataTypeEntry.getSuffixTokens() != null) {
            for (Integer suffixTokenIdentifier : dataTypeEntry.getSuffixTokens()) {
                if (dataTypeContext.getToken(suffixTokenIdentifier.intValue(), 0) == null) continue;
                dataTypeBuilder.addToName(dataTypeContext.getToken(suffixTokenIdentifier.intValue(), 0).getText());
            }
        }
    }

    public static class DataTypeEntry {
        private final int jdbcDataType;
        private final Integer[] dbmsDataTypeTokenIdentifiers;
        private Integer[] suffixTokens = null;
        private int defaultLength = -1;
        private int defaultScale = -1;

        public DataTypeEntry(int jdbcDataType, Integer ... dbmsDataTypeTokenIdentifiers) {
            this.dbmsDataTypeTokenIdentifiers = dbmsDataTypeTokenIdentifiers;
            this.jdbcDataType = jdbcDataType;
        }

        Integer[] getDbmsDataTypeTokenIdentifiers() {
            return this.dbmsDataTypeTokenIdentifiers;
        }

        int getJdbcDataType() {
            return this.jdbcDataType;
        }

        Integer[] getSuffixTokens() {
            return this.suffixTokens;
        }

        int getDefaultLength() {
            return this.defaultLength;
        }

        int getDefaultScale() {
            return this.defaultScale;
        }

        public DataTypeEntry setSuffixTokens(Integer ... suffixTokens) {
            this.suffixTokens = suffixTokens;
            return this;
        }

        public DataTypeEntry setDefaultLengthDimension(int defaultLength) {
            this.defaultLength = defaultLength;
            return this;
        }

        public DataTypeEntry setDefaultLengthScaleDimension(int defaultLength, int defaultScale) {
            this.defaultLength = defaultLength;
            this.defaultScale = defaultScale;
            return this;
        }

        public String toString() {
            return "DataTypeEntry [jdbcDataType=" + this.jdbcDataType + ", dbmsDataTypeTokenIdentifiers=" + Arrays.toString((Object[])this.dbmsDataTypeTokenIdentifiers) + ", suffixTokens=" + Arrays.toString((Object[])this.suffixTokens) + ", defaultLength=" + this.defaultLength + ", defaultScale=" + this.defaultScale + "]";
        }
    }

    public static class Builder {
        private final Map<String, List<DataTypeEntry>> contextDataTypesMap = new HashMap<String, List<DataTypeEntry>>();

        public void registerDataTypes(String contextClassCanonicalName, List<DataTypeEntry> dataTypeEntries) {
            this.contextDataTypesMap.put(contextClassCanonicalName, Collections.unmodifiableList(dataTypeEntries));
        }

        public DataTypeResolver build() {
            return new DataTypeResolver(this.contextDataTypesMap);
        }
    }
}

