/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.spatial;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class GeometryUtil {
    public static boolean isExtended(byte[] wkb) {
        if (wkb == null || wkb.length < 5) {
            return false;
        }
        ByteBuffer buffer = ByteBuffer.wrap(wkb);
        buffer.order(GeometryUtil.getByteOrder(buffer.get()));
        int type = buffer.getInt();
        return (type & 0x20000000) != 0;
    }

    public static Integer extractSrid(byte[] ewkb) {
        if (ewkb == null || ewkb.length < 5) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(ewkb);
        byte byteOrder = buffer.get();
        buffer.order(GeometryUtil.getByteOrder(byteOrder));
        int wkbType = buffer.getInt();
        if (GeometryUtil.hasSrid(wkbType)) {
            return buffer.getInt();
        }
        return null;
    }

    public static boolean hasSrid(int wkbType) {
        return (wkbType & 0x20000000) != 0;
    }

    public static ByteOrder getByteOrder(byte byteOrder) {
        return byteOrder == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public static byte getByteOrderByte(ByteOrder byteOrder) {
        return (byte)(byteOrder == ByteOrder.LITTLE_ENDIAN ? 1 : 0);
    }

    private GeometryUtil() {
    }
}

