/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.spatial;

import io.debezium.DebeziumException;
import io.debezium.spatial.GeometryUtil;
import io.debezium.spatial.GeometryVisitor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class GeometryTraverser {
    GeometryTraverser() {
    }

    public static void traverse(ByteBuffer buffer, GeometryVisitor visitor) {
        int stride;
        boolean hasM;
        int wkbType;
        boolean hasZ = ((wkbType = buffer.getInt()) & Integer.MIN_VALUE) != 0;
        if (!visitor.enterGeometry(wkbType, hasZ, hasM = (wkbType & 0x40000000) != 0, stride = 2 + (hasZ ? 1 : 0) + (hasM ? 1 : 0))) {
            return;
        }
        if (GeometryUtil.hasSrid(wkbType)) {
            visitor.visitSrid(buffer.getInt());
        }
        int baseType = wkbType & 0xFF;
        switch (baseType) {
            case 1: {
                GeometryTraverser.traversePoint(buffer, visitor, stride);
                break;
            }
            case 2: {
                GeometryTraverser.traverseLineString(buffer, visitor, stride);
                break;
            }
            case 3: {
                GeometryTraverser.traversePolygon(buffer, visitor, stride);
                break;
            }
            case 4: {
                GeometryTraverser.traverseMultiPoint(buffer, visitor, stride);
                break;
            }
            case 5: {
                GeometryTraverser.traverseMultiLineString(buffer, visitor, stride);
                break;
            }
            case 6: {
                GeometryTraverser.traverseMultiPolygon(buffer, visitor, stride);
                break;
            }
            case 7: {
                GeometryTraverser.traverseGeometryCollection(buffer, visitor);
                break;
            }
            default: {
                throw new DebeziumException("Invalid geometry type: " + baseType);
            }
        }
        visitor.exitGeometry();
    }

    private static void traversePoint(ByteBuffer buffer, GeometryVisitor visitor, int stride) {
        double[] ordinates = new double[stride];
        for (int i = 0; i < stride; ++i) {
            ordinates[i] = buffer.getDouble();
        }
        visitor.visitCoordinate(ordinates);
    }

    private static void traverseLineString(ByteBuffer buffer, GeometryVisitor visitor, int stride) {
        int numPoints = buffer.getInt();
        visitor.startLineString(numPoints);
        for (int i = 0; i < numPoints; ++i) {
            GeometryTraverser.traversePoint(buffer, visitor, stride);
        }
        visitor.endLineString();
    }

    private static void traversePolygon(ByteBuffer buffer, GeometryVisitor visitor, int stride) {
        int numRings = buffer.getInt();
        visitor.startPolygon(numRings);
        for (int i = 0; i < numRings; ++i) {
            int numPoints = buffer.getInt();
            visitor.startRing(i, numPoints);
            for (int j = 0; j < numPoints; ++j) {
                GeometryTraverser.traversePoint(buffer, visitor, stride);
            }
            visitor.endRing();
        }
        visitor.endPolygon();
    }

    private static void traverseMultiPoint(ByteBuffer buffer, GeometryVisitor visitor, int stride) {
        int numGeometries = buffer.getInt();
        visitor.startMultiPoint(numGeometries);
        for (int i = 0; i < numGeometries; ++i) {
            byte byteOrder = buffer.get();
            ByteOrder order = GeometryUtil.getByteOrder(byteOrder);
            try (ByteOrderScope scope = new ByteOrderScope(buffer, order);){
                int wkbType = buffer.getInt();
                if (!visitor.enterSubGeometry(byteOrder, wkbType)) continue;
                GeometryTraverser.traversePoint(buffer, visitor, stride);
                visitor.exitSubGeometry();
                continue;
            }
        }
        visitor.endMultiPoint();
    }

    private static void traverseMultiLineString(ByteBuffer buffer, GeometryVisitor visitor, int stride) {
        int numGeometries = buffer.getInt();
        visitor.startMultiLineString(numGeometries);
        for (int i = 0; i < numGeometries; ++i) {
            byte byteOrder = buffer.get();
            ByteOrder order = GeometryUtil.getByteOrder(byteOrder);
            try (ByteOrderScope scope = new ByteOrderScope(buffer, order);){
                int wkbType = buffer.getInt();
                if (!visitor.enterSubGeometry(byteOrder, wkbType)) continue;
                GeometryTraverser.traverseLineString(buffer, visitor, stride);
                visitor.exitSubGeometry();
                continue;
            }
        }
        visitor.endMultiLineString();
    }

    private static void traverseMultiPolygon(ByteBuffer buffer, GeometryVisitor visitor, int stride) {
        int numGeometries = buffer.getInt();
        visitor.startMultiPolygon(numGeometries);
        for (int i = 0; i < numGeometries; ++i) {
            byte byteOrder = buffer.get();
            ByteOrder order = GeometryUtil.getByteOrder(byteOrder);
            try (ByteOrderScope scope = new ByteOrderScope(buffer, order);){
                int wkbType = buffer.getInt();
                if (!visitor.enterSubGeometry(byteOrder, wkbType)) continue;
                GeometryTraverser.traversePolygon(buffer, visitor, stride);
                visitor.exitSubGeometry();
                continue;
            }
        }
        visitor.endMultiPolygon();
    }

    private static void traverseGeometryCollection(ByteBuffer buffer, GeometryVisitor visitor) {
        int numGeometries = buffer.getInt();
        visitor.startGeometryCollection(numGeometries);
        for (int i = 0; i < numGeometries; ++i) {
            byte byteOrder = buffer.get();
            ByteOrder order = GeometryUtil.getByteOrder(byteOrder);
            try (ByteOrderScope scope = new ByteOrderScope(buffer, order);){
                if (!visitor.enterCollectionGeometry(byteOrder)) continue;
                GeometryTraverser.traverse(buffer, visitor);
                visitor.exitCollectionGeometry();
                continue;
            }
        }
        visitor.endGeometryCollection();
    }

    private static class ByteOrderScope
    implements AutoCloseable {
        private final ByteBuffer buffer;
        private final ByteOrder byteOrder;

        ByteOrderScope(ByteBuffer buffer, ByteOrder newByteOrder) {
            this.buffer = buffer;
            this.byteOrder = buffer.order();
            if (buffer.order() != newByteOrder) {
                buffer.order(newByteOrder);
            }
        }

        @Override
        public void close() {
            if (this.buffer.order() != this.byteOrder) {
                this.buffer.order(this.byteOrder);
            }
        }
    }
}

