/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.heartbeat;

import io.debezium.function.BlockingConsumer;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.pipeline.spi.OffsetContext;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.source.SourceRecord;

public class CompositeHeartbeat
implements Heartbeat,
Heartbeat.ScheduledHeartbeat {
    private final Heartbeat.ScheduledHeartbeat scheduledHeartbeat;
    private final List<Heartbeat> heartbeats;

    public CompositeHeartbeat(Heartbeat.ScheduledHeartbeat scheduledHeartbeat, Heartbeat ... heartbeat) {
        this.scheduledHeartbeat = scheduledHeartbeat;
        this.heartbeats = Arrays.stream(heartbeat).toList();
    }

    public CompositeHeartbeat(Heartbeat.ScheduledHeartbeat scheduledHeartbeat, List<Heartbeat> heartbeats) {
        this.scheduledHeartbeat = scheduledHeartbeat;
        this.heartbeats = heartbeats;
    }

    @Override
    public void heartbeat(Map<String, ?> partition, Map<String, ?> offset, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
        for (Heartbeat heartbeat : this.heartbeats) {
            heartbeat.heartbeat(partition, offset, consumer);
        }
    }

    @Override
    public void heartbeat(Map<String, ?> partition, Heartbeat.OffsetProducer offsetProducer, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
        for (Heartbeat heartbeat : this.heartbeats) {
            heartbeat.heartbeat(partition, offsetProducer, consumer);
        }
    }

    @Override
    public void forcedBeat(Map<String, ?> partition, Map<String, ?> offset, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
        for (Heartbeat heartbeat : this.heartbeats) {
            heartbeat.heartbeat(partition, offset, consumer);
        }
    }

    @Override
    public void emitWithDelay(Map<String, ?> partition, OffsetContext offset) throws InterruptedException {
        this.scheduledHeartbeat.emitWithDelay(partition, offset);
        for (Heartbeat heartbeat : this.heartbeats) {
            heartbeat.emit(partition, offset);
        }
    }

    @Override
    public void emit(Map<String, ?> partition, OffsetContext offset) throws InterruptedException {
        this.scheduledHeartbeat.emit(partition, offset);
        for (Heartbeat heartbeat : this.heartbeats) {
            heartbeat.emit(partition, offset);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.heartbeats.stream().anyMatch(Heartbeat::isEnabled);
    }

    @Override
    public void close() {
        for (Heartbeat heartbeat : this.heartbeats) {
            heartbeat.close();
        }
    }
}

