/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.openlineage.emitter;

import io.debezium.config.Configuration;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.openlineage.ConnectorContext;
import io.debezium.openlineage.OpenLineageContext;
import io.debezium.openlineage.OpenLineageJobCreator;
import io.debezium.openlineage.ProcessingEngineMetadata;
import io.debezium.openlineage.dataset.DatasetMetadata;
import io.debezium.openlineage.dataset.InputDatasetNamespaceResolver;
import io.debezium.openlineage.dataset.OutputDatasetNamespaceResolver;
import io.debezium.openlineage.emitter.LineageEmitter;
import io.debezium.openlineage.emitter.OpenLineageEventEmitter;
import io.debezium.openlineage.facets.DebeziumConfigFacet;
import io.openlineage.client.OpenLineage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.ZonedDateTime;
import java.util.List;

public class OpenLineageEmitter
implements LineageEmitter {
    private static final String JAVA = "Java";
    public static final String DATASET_TYPE = "TABLE";
    private final OpenLineageContext openLineageContext;
    private final String connectorName;
    private final OpenLineageEventEmitter emitter;
    private final Configuration config;
    private final InputDatasetNamespaceResolver inputDatasetNamespaceResolver;
    private final OutputDatasetNamespaceResolver outputDatasetNamespaceResolver;

    public OpenLineageEmitter(ConnectorContext connectorContext, OpenLineageContext openLineageContext, OpenLineageEventEmitter emitter, InputDatasetNamespaceResolver inputDatasetNamespaceResolver, OutputDatasetNamespaceResolver outputDatasetNamespaceResolver) {
        this.openLineageContext = openLineageContext;
        this.connectorName = connectorContext.connectorName();
        this.emitter = emitter;
        this.config = connectorContext.config();
        this.inputDatasetNamespaceResolver = inputDatasetNamespaceResolver;
        this.outputDatasetNamespaceResolver = outputDatasetNamespaceResolver;
    }

    @Override
    public void emit(BaseSourceTask.State state) {
        this.emit(state, List.of(), null);
    }

    @Override
    public void emit(BaseSourceTask.State state, Throwable t) {
        this.emit(state, List.of(), t);
    }

    @Override
    public void emit(BaseSourceTask.State state, List<DatasetMetadata> datasetMetadata) {
        this.emit(state, datasetMetadata, null);
    }

    @Override
    public void emit(BaseSourceTask.State state, List<DatasetMetadata> datasetMetadata, Throwable t) {
        OpenLineage.Job job = new OpenLineageJobCreator(this.openLineageContext).create();
        List<OpenLineage.InputDataset> inputs = this.getInputDatasets(datasetMetadata);
        List<OpenLineage.OutputDataset> outputs = this.getOutputDatasets(datasetMetadata);
        OpenLineage.RunFacetsBuilder runFacetsBuilder = this.openLineageContext.getOpenLineage().newRunFacetsBuilder().processing_engine(this.openLineageContext.getOpenLineage().newProcessingEngineRunFacet(ProcessingEngineMetadata.debezium().version(), ProcessingEngineMetadata.debezium().name(), ProcessingEngineMetadata.debezium().openlineageAdapterVersion())).nominalTime(this.openLineageContext.getOpenLineage().newNominalTimeRunFacetBuilder().nominalStartTime(ZonedDateTime.now()).nominalEndTime(ZonedDateTime.now()).build()).put("debezium_config", (OpenLineage.RunFacet)new DebeziumConfigFacet(this.emitter.getProducer(), this.config.asMap()));
        this.addStackTrace(t, runFacetsBuilder);
        OpenLineage.RunEvent startEvent = this.openLineageContext.getOpenLineage().newRunEventBuilder().eventType(OpenLineageEmitter.getEventType(state)).eventTime(ZonedDateTime.now()).run(this.openLineageContext.getOpenLineage().newRun(this.openLineageContext.getRunUuid(), runFacetsBuilder.build())).inputs(inputs).outputs(outputs).job(job).build();
        this.emitter.emit(startEvent);
    }

    private void addStackTrace(Throwable t, OpenLineage.RunFacetsBuilder runFacetsBuilder) {
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            runFacetsBuilder.errorMessage(this.openLineageContext.getOpenLineage().newErrorMessageRunFacet(t.getMessage(), JAVA, sw.toString()));
        }
    }

    private List<OpenLineage.InputDataset> getInputDatasets(List<DatasetMetadata> datasetMetadata) {
        return datasetMetadata.stream().filter(dataset -> DatasetMetadata.DatasetType.INPUT.equals((Object)dataset.type())).map(this::mapToInputDataset).toList();
    }

    private List<OpenLineage.OutputDataset> getOutputDatasets(List<DatasetMetadata> datasetMetadata) {
        return datasetMetadata.stream().filter(dataset -> DatasetMetadata.DatasetType.OUTPUT.equals((Object)dataset.type())).map(this::mapToOutputDataset).toList();
    }

    private OpenLineage.OutputDataset mapToOutputDataset(DatasetMetadata outputDatasetMetadata) {
        List<OpenLineage.SchemaDatasetFacetFields> datasetFields = outputDatasetMetadata.fields().stream().map(this::buildSchemaDatasetFacetFields).toList();
        return this.openLineageContext.getOpenLineage().newOutputDatasetBuilder().namespace(this.outputDatasetNamespaceResolver.resolve(this.config)).name(outputDatasetMetadata.name()).facets(this.openLineageContext.getOpenLineage().newDatasetFacetsBuilder().schema(this.openLineageContext.getOpenLineage().newSchemaDatasetFacetBuilder().fields(datasetFields).build()).datasetType(this.openLineageContext.getOpenLineage().newDatasetTypeDatasetFacet(DATASET_TYPE, "")).build()).build();
    }

    private OpenLineage.SchemaDatasetFacetFields buildSchemaDatasetFacetFields(DatasetMetadata.FieldDefinition fieldDefinition) {
        if (fieldDefinition.fields() != null && !fieldDefinition.fields().isEmpty()) {
            List<OpenLineage.SchemaDatasetFacetFields> nestedFields = fieldDefinition.fields().stream().map(this::buildSchemaDatasetFacetFields).toList();
            return this.openLineageContext.getOpenLineage().newSchemaDatasetFacetFieldsBuilder().name(fieldDefinition.name()).type(fieldDefinition.typeName()).description(fieldDefinition.description()).fields(nestedFields).build();
        }
        return this.openLineageContext.getOpenLineage().newSchemaDatasetFacetFieldsBuilder().name(fieldDefinition.name()).type(fieldDefinition.typeName()).description(fieldDefinition.description()).build();
    }

    private OpenLineage.InputDataset mapToInputDataset(DatasetMetadata inputDatasetMetadata) {
        List<OpenLineage.SchemaDatasetFacetFields> datasetFields = inputDatasetMetadata.fields().stream().map(datasetMetadata -> this.openLineageContext.getOpenLineage().newSchemaDatasetFacetFieldsBuilder().name(datasetMetadata.name()).type(datasetMetadata.typeName()).description(datasetMetadata.description()).build()).toList();
        return this.openLineageContext.getOpenLineage().newInputDatasetBuilder().namespace(this.inputDatasetNamespaceResolver.resolve(this.config, this.connectorName)).name(inputDatasetMetadata.name()).facets(this.openLineageContext.getOpenLineage().newDatasetFacetsBuilder().schema(this.openLineageContext.getOpenLineage().newSchemaDatasetFacetBuilder().fields(datasetFields).build()).datasetType(this.openLineageContext.getOpenLineage().newDatasetTypeDatasetFacet(DATASET_TYPE, "")).build()).build();
    }

    private static OpenLineage.RunEvent.EventType getEventType(BaseSourceTask.State state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case BaseSourceTask.State.INITIAL -> OpenLineage.RunEvent.EventType.START;
            case BaseSourceTask.State.RUNNING -> OpenLineage.RunEvent.EventType.RUNNING;
            case BaseSourceTask.State.RESTARTING -> OpenLineage.RunEvent.EventType.FAIL;
            case BaseSourceTask.State.STOPPED -> OpenLineage.RunEvent.EventType.COMPLETE;
        };
    }

    public OpenLineageContext getContext() {
        return this.openLineageContext;
    }
}

