/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.openlineage;

import io.debezium.openlineage.OpenLineageContext;
import io.openlineage.client.OpenLineage;
import java.util.List;

public class OpenLineageJobCreator {
    private static final String PROCESSING_TYPE = "STREAMING";
    private static final String INTEGRATION = "DEBEZIUM";
    private static final String JOB_TYPE = "TASK";
    private static final String TAGS_SOURCE = "CONFIG";
    private final OpenLineageContext context;

    public OpenLineageJobCreator(OpenLineageContext context) {
        this.context = context;
    }

    public OpenLineage.Job create() {
        List<OpenLineage.TagsJobFacetFields> tags = this.context.getConfiguration().job().tags().entrySet().stream().map(pair -> this.context.getOpenLineage().newTagsJobFacetFields((String)pair.getKey(), (String)pair.getValue(), TAGS_SOURCE)).toList();
        List<OpenLineage.OwnershipJobFacetOwners> owners = this.context.getConfiguration().job().owners().entrySet().stream().map(pair -> this.context.getOpenLineage().newOwnershipJobFacetOwners((String)pair.getKey(), (String)pair.getValue())).toList();
        OpenLineage.JobFacets jobFacets = this.context.getOpenLineage().newJobFacetsBuilder().documentation(this.context.getOpenLineage().newDocumentationJobFacet(this.context.getConfiguration().job().description())).ownership(this.context.getOpenLineage().newOwnershipJobFacet(owners)).tags(this.context.getOpenLineage().newTagsJobFacet(tags)).jobType(this.context.getOpenLineage().newJobTypeJobFacet(PROCESSING_TYPE, INTEGRATION, JOB_TYPE)).build();
        return this.context.getOpenLineage().newJobBuilder().namespace(this.context.getJobIdentifier().namespace()).name(this.context.getJobIdentifier().name()).facets(jobFacets).build();
    }
}

