/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.openlineage;

import io.debezium.config.Configuration;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.openlineage.ConnectorContext;
import io.debezium.openlineage.dataset.DatasetMetadata;
import io.debezium.openlineage.emitter.LineageEmitter;
import io.debezium.openlineage.emitter.LineageEmitterFactory;
import io.debezium.openlineage.emitter.NoOpLineageEmitter;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumOpenLineageEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebeziumOpenLineageEmitter.class);
    private static final ServiceLoader<LineageEmitterFactory> lineageEmitterFactory = ServiceLoader.load(LineageEmitterFactory.class);
    private static final Object SERVICE_LOADER_LOCK = new Object();
    private static final ConcurrentHashMap<String, LineageEmitter> emitters = new ConcurrentHashMap();

    public static void init(Configuration configuration, String connectorTypeName) {
        LOGGER.debug("Calling init for connector {} and config {}", (Object)connectorTypeName, (Object)configuration);
        ConnectorContext connectorContext = ConnectorContext.from(configuration, connectorTypeName);
        LineageEmitter emitter = emitters.computeIfAbsent(connectorContext.toEmitterKey(), key -> {
            LOGGER.debug("Creating new emitter for connector with name {}", key);
            Object object = SERVICE_LOADER_LOCK;
            synchronized (object) {
                return lineageEmitterFactory.stream().findFirst().map(ServiceLoader.Provider::get).orElse(ignore -> new NoOpLineageEmitter()).get(connectorContext);
            }
        });
        LOGGER.debug("Emitter instance for connector {}: {}", (Object)connectorTypeName, (Object)emitter);
    }

    public static void cleanup(ConnectorContext connectorContext) {
        LineageEmitter removed = emitters.remove(connectorContext.toEmitterKey());
        if (removed != null) {
            LOGGER.debug("Cleaned up emitter for connector {}", (Object)connectorContext);
        }
    }

    public static ConnectorContext connectorContext(Configuration config, String connectorName) {
        return ConnectorContext.from(config, connectorName);
    }

    public static void emit(ConnectorContext connectorContext, BaseSourceTask.State state) {
        DebeziumOpenLineageEmitter.getEmitter(connectorContext).emit(state);
    }

    public static void emit(ConnectorContext connectorContext, BaseSourceTask.State state, Throwable t) {
        DebeziumOpenLineageEmitter.getEmitter(connectorContext).emit(state, List.of(), t);
    }

    public static void emit(ConnectorContext connectorContext, BaseSourceTask.State state, List<DatasetMetadata> datasetMetadata) {
        DebeziumOpenLineageEmitter.getEmitter(connectorContext).emit(state, datasetMetadata);
    }

    public static void emit(ConnectorContext connectorContext, BaseSourceTask.State state, List<DatasetMetadata> datasetMetadata, Throwable t) {
        DebeziumOpenLineageEmitter.getEmitter(connectorContext).emit(state, datasetMetadata, t);
    }

    private static LineageEmitter getEmitter(ConnectorContext connectorContext) {
        LineageEmitter emitter = emitters.get(connectorContext.toEmitterKey());
        if (emitter == null) {
            throw new IllegalStateException("DebeziumOpenLineageEmitter not initialized for connector " + String.valueOf(connectorContext) + ". Call init() first.");
        }
        return emitter;
    }
}

