/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.document.Array;
import io.debezium.document.Document;
import io.debezium.function.Predicates;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.JsonTableChangeSerializer;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.relational.history.SchemaHistoryException;
import io.debezium.relational.history.SchemaHistoryListener;
import io.debezium.relational.history.TableChanges;
import io.debezium.text.MultipleParsingExceptions;
import io.debezium.text.ParsingException;
import io.debezium.util.Clock;
import io.debezium.util.Loggings;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaHistory
implements SchemaHistory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static Field.Set ALL_FIELDS = Field.setOf(NAME, INTERNAL_CONNECTOR_CLASS, INTERNAL_CONNECTOR_ID);
    protected Configuration config;
    private HistoryRecordComparator comparator = HistoryRecordComparator.INSTANCE;
    private boolean skipUnparseableDDL;
    private Predicate<String> ddlFilter = x -> false;
    private SchemaHistoryListener listener = SchemaHistoryListener.NOOP;
    private boolean useCatalogBeforeSchema;
    private boolean preferDdl = false;
    private final TableChanges.TableChangesSerializer<Array> tableChangesSerializer = new JsonTableChangeSerializer();

    protected AbstractSchemaHistory() {
    }

    @Override
    public void configure(Configuration config, HistoryRecordComparator comparator, SchemaHistoryListener listener, boolean useCatalogBeforeSchema) {
        this.config = config;
        this.comparator = comparator != null ? comparator : HistoryRecordComparator.INSTANCE;
        this.skipUnparseableDDL = config.getBoolean(SKIP_UNPARSEABLE_DDL_STATEMENTS);
        String ddlFilter = config.getString(DDL_FILTER);
        this.ddlFilter = ddlFilter != null ? Predicates.includes(ddlFilter, 34) : x -> false;
        this.listener = listener;
        this.useCatalogBeforeSchema = useCatalogBeforeSchema;
        this.preferDdl = config.getBoolean(INTERNAL_PREFER_DDL);
    }

    @Override
    public void start() {
        this.listener.started();
    }

    @Override
    public final void record(Map<String, ?> source, Map<String, ?> position, String databaseName, String ddl) throws SchemaHistoryException {
        this.record(source, position, databaseName, null, ddl, null, Clock.SYSTEM.currentTimeAsInstant());
    }

    @Override
    public final void record(Map<String, ?> source, Map<String, ?> position, String databaseName, String schemaName, String ddl, TableChanges changes, Instant timestamp) throws SchemaHistoryException {
        HistoryRecord record = new HistoryRecord(source, position, databaseName, schemaName, ddl, changes, timestamp);
        this.storeRecord(record);
        this.listener.onChangeApplied(record);
    }

    @Override
    public void recover(Map<Map<String, ?>, Map<String, ?>> offsets, Tables schema, DdlParser ddlParser) {
        this.listener.recoveryStarted();
        HashMap stopPoints = new HashMap();
        offsets.forEach((source, position) -> {
            Document srcDocument = Document.create();
            if (source != null) {
                source.forEach(srcDocument::set);
            }
            stopPoints.put(srcDocument, new HistoryRecord((Map<String, ?>)source, (Map<String, ?>)position, null, null, null, null, null));
        });
        this.recoverRecords(recovered -> {
            this.listener.onChangeFromHistory((HistoryRecord)recovered);
            Document srcDocument = recovered.document().getDocument("source");
            if (stopPoints.containsKey(srcDocument) && this.comparator.isAtOrBefore((HistoryRecord)recovered, (HistoryRecord)stopPoints.get(srcDocument))) {
                Array tableChanges = recovered.tableChanges();
                String ddl = recovered.ddl();
                if (!this.preferDdl && tableChanges != null && !tableChanges.isEmpty()) {
                    TableChanges changes = this.tableChangesSerializer.deserialize(tableChanges, this.useCatalogBeforeSchema);
                    for (TableChanges.TableChange entry : changes) {
                        if (entry.getType() == TableChanges.TableChangeType.CREATE) {
                            schema.overwriteTable(entry.getTable());
                            continue;
                        }
                        if (entry.getType() == TableChanges.TableChangeType.ALTER) {
                            if (entry.getPreviousId() != null) {
                                schema.removeTable(entry.getPreviousId());
                            }
                            schema.overwriteTable(entry.getTable());
                            continue;
                        }
                        schema.removeTable(entry.getId());
                    }
                    this.listener.onChangeApplied((HistoryRecord)recovered);
                } else if (ddl != null && ddlParser != null) {
                    if (recovered.databaseName() != null) {
                        ddlParser.setCurrentDatabase(recovered.databaseName());
                    }
                    if (recovered.schemaName() != null) {
                        ddlParser.setCurrentSchema(recovered.schemaName());
                    }
                    if (this.ddlFilter.test(ddl)) {
                        this.logger.info("a DDL '{}' was filtered out of processing by regular expression '{}'", Loggings.maybeRedactSensitiveData(ddl), (Object)this.config.getString(DDL_FILTER));
                        return;
                    }
                    try {
                        this.logger.debug("Applying: {}", (Object)ddl);
                        ddlParser.parse(ddl, schema);
                        this.listener.onChangeApplied((HistoryRecord)recovered);
                    }
                    catch (MultipleParsingExceptions | ParsingException e) {
                        if (this.skipUnparseableDDL) {
                            this.logger.warn("Ignoring unparseable statements '{}' stored in database schema history", (Object)ddl, (Object)e);
                        }
                        throw e;
                    }
                }
            } else {
                this.logger.debug("Skipping: {}", (Object)recovered.ddl());
            }
        });
        this.listener.recoveryStopped();
    }

    protected abstract void storeRecord(HistoryRecord var1) throws SchemaHistoryException;

    protected abstract void recoverRecords(Consumer<HistoryRecord> var1);

    @Override
    public void stop() {
        this.listener.stopped();
    }

    @Override
    public void initializeStorage() {
    }
}

