/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.tracing;

import io.debezium.transforms.tracing.KafkaConnectHeadersSetter;
import io.debezium.transforms.tracing.PropertiesGetter;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingSpanUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TracingSpanUtil.class);
    private static final String DB_FIELDS_PREFIX = "db.";
    private static final String TX_LOG_WRITE_OPERATION_NAME = "db-log-write";
    private static final String TRACING_COMPONENT = TracingSpanUtil.class.getName();
    private static final OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
    private static final Tracer tracer = openTelemetry.getTracer(TRACING_COMPONENT);

    private TracingSpanUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends ConnectRecord<R>> R traceRecord(R connectRecord, Struct envelope, Struct source, String propagatedSpanContext, String operationName) {
        Long eventTimestamp;
        SpanBuilder txLogSpanBuilder = tracer.spanBuilder(TX_LOG_WRITE_OPERATION_NAME).setSpanKind(SpanKind.INTERNAL);
        if (propagatedSpanContext != null) {
            Properties props = PropertiesGetter.extract(propagatedSpanContext);
            Context parentSpanContext = openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)props, (TextMapGetter)PropertiesGetter.INSTANCE);
            txLogSpanBuilder.setParent(parentSpanContext);
        }
        if (source != null && (eventTimestamp = source.getInt64("ts_ms")) != null) {
            txLogSpanBuilder.setStartTimestamp(eventTimestamp.longValue(), TimeUnit.MILLISECONDS);
        }
        Span txLogSpan = txLogSpanBuilder.startSpan();
        try (Scope ignored = txLogSpan.makeCurrent();){
            if (source != null) {
                for (Field field : source.schema().fields()) {
                    TracingSpanUtil.addFieldToSpan(txLogSpan, source, field.name(), DB_FIELDS_PREFIX);
                }
            }
            TracingSpanUtil.debeziumSpan(envelope, operationName);
            TextMapPropagator textMapPropagator = openTelemetry.getPropagators().getTextMapPropagator();
            textMapPropagator.inject(Context.current(), (Object)connectRecord.headers(), (TextMapSetter)KafkaConnectHeadersSetter.INSTANCE);
        }
        finally {
            txLogSpan.end();
        }
        return connectRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void debeziumSpan(Struct envelope, String operationName) {
        Long processingTimestamp = envelope.getInt64("ts_ms");
        Span debeziumSpan = tracer.spanBuilder(operationName).setStartTimestamp(processingTimestamp.longValue(), TimeUnit.MILLISECONDS).startSpan();
        try (Scope ignored = debeziumSpan.makeCurrent();){
            TracingSpanUtil.addFieldToSpan(debeziumSpan, envelope, "op", "");
            TracingSpanUtil.addFieldToSpan(debeziumSpan, envelope, "ts_ms", "");
        }
        finally {
            debeziumSpan.end();
        }
    }

    private static void addFieldToSpan(Span span, Struct struct, String field, String prefix) {
        Object fieldValue = struct.get(field);
        if (fieldValue != null) {
            String targetFieldName = prefix + field;
            if (DB_FIELDS_PREFIX.equals(prefix)) {
                if ("db".equals(field)) {
                    targetFieldName = prefix + "instance";
                } else if ("connector".equals(field)) {
                    targetFieldName = prefix + "type";
                } else if ("name".equals(field)) {
                    targetFieldName = prefix + "cdc-name";
                }
            }
            span.setAttribute(targetFieldName, fieldValue.toString());
        }
    }
}

