/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;
import io.debezium.data.Envelope;
import io.debezium.data.SchemaUtil;
import io.debezium.relational.StructGenerator;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.util.Loggings;
import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class TableSchema
implements DataCollectionSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableSchema.class);
    private final TableId id;
    private final Schema keySchema;
    private final Envelope envelopeSchema;
    private final Schema valueSchema;
    private final StructGenerator keyGenerator;
    private final StructGenerator valueGenerator;

    public TableSchema(TableId id, Schema keySchema, StructGenerator keyGenerator, Envelope envelopeSchema, Schema valueSchema, StructGenerator valueGenerator) {
        this.id = id;
        this.keySchema = keySchema;
        this.envelopeSchema = envelopeSchema;
        this.valueSchema = valueSchema;
        this.keyGenerator = keyGenerator != null ? keyGenerator : row -> null;
        this.valueGenerator = valueGenerator != null ? valueGenerator : row -> null;
    }

    @Override
    public TableId id() {
        return this.id;
    }

    public Schema valueSchema() {
        return this.valueSchema;
    }

    @Override
    public Schema keySchema() {
        return this.keySchema;
    }

    @Override
    public Envelope getEnvelopeSchema() {
        return this.envelopeSchema;
    }

    public Struct keyFromColumnData(Object[] columnData) {
        if (LOGGER.isTraceEnabled()) {
            Loggings.logTraceAndTraceRecord(LOGGER, Arrays.toString(columnData), "columnData from current stack", new Object[0]);
        }
        return columnData == null ? null : this.keyGenerator.generateValue(columnData);
    }

    public Struct valueFromColumnData(Object[] columnData) {
        return columnData == null ? null : this.valueGenerator.generateValue(columnData);
    }

    public int hashCode() {
        return this.valueSchema().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TableSchema) {
            TableSchema that = (TableSchema)obj;
            return Objects.equals(this.keySchema(), that.keySchema()) && Objects.equals(this.valueSchema(), that.valueSchema());
        }
        return false;
    }

    public String toString() {
        return "{ key : " + SchemaUtil.asString(this.keySchema()) + ", value : " + SchemaUtil.asString(this.valueSchema()) + " }";
    }
}

