/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source.snapshot.incremental;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.source.snapshot.incremental.SignalMetadata;
import io.debezium.pipeline.source.snapshot.incremental.WatermarkWindowCloser;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertWindowCloser
implements WatermarkWindowCloser {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsertWindowCloser.class);
    public static final String INSERT_STATEMENT = "INSERT INTO %s VALUES (?, ?, ?)";
    private final JdbcConnection jdbcConnection;
    private final String signalWindowStatement;
    private final SignalMetadata signalMetadata;

    public InsertWindowCloser(JdbcConnection jdbcConnection, String signalTable, SignalMetadata signalMetadata) {
        this.jdbcConnection = jdbcConnection;
        this.signalWindowStatement = String.format(INSERT_STATEMENT, signalTable);
        this.signalMetadata = signalMetadata;
    }

    @Override
    public void closeWindow(Partition partition, OffsetContext offsetContext, String chunkId) throws SQLException {
        this.jdbcConnection.prepareUpdate(this.signalWindowStatement, x -> {
            LOGGER.trace("Emitting close window for chunk = '{}'", (Object)chunkId);
            x.setString(1, chunkId + "-close");
            x.setString(2, "snapshot-window-close");
            x.setString(3, this.signalMetadata.metadataString());
        });
        this.jdbcConnection.commit();
    }
}

