/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.base.ChangeEventQueue;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.RetriableException;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandler {
    public static final int RETRIES_UNLIMITED = -1;
    public static final int RETRIES_DISABLED = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandler.class);
    private final ChangeEventQueue<?> queue;
    private final AtomicReference<Throwable> producerThrowable;
    private final CommonConnectorConfig connectorConfig;
    private int maxRetries;
    private int retries;

    public ErrorHandler(Class<? extends SourceConnector> connectorType, CommonConnectorConfig connectorConfig, ChangeEventQueue<?> queue, ErrorHandler replacedErrorHandler) {
        this.connectorConfig = connectorConfig;
        this.queue = queue;
        this.producerThrowable = new AtomicReference();
        this.maxRetries = connectorConfig != null ? connectorConfig.getMaxRetriesOnError() : -1;
        if (replacedErrorHandler != null) {
            this.retries = replacedErrorHandler.getRetries();
        }
    }

    public void setProducerThrowable(Throwable producerThrowable) {
        LOGGER.error("Producer failure", producerThrowable);
        boolean first = this.producerThrowable.compareAndSet(null, producerThrowable);
        boolean retriable = this.isRetriable(producerThrowable);
        if (!retriable) {
            retriable = this.isCustomRetriable(producerThrowable);
        }
        if (first) {
            if (retriable && this.hasMoreRetries()) {
                this.queue.producerException((RuntimeException)((Object)new RetriableException("An exception occurred in the change event producer. This connector will be restarted.", producerThrowable)));
            } else {
                this.queue.producerException((RuntimeException)new ConnectException("An exception occurred in the change event producer. This connector will be stopped.", producerThrowable));
            }
        }
    }

    public Throwable getProducerThrowable() {
        return this.producerThrowable.get();
    }

    protected Set<Class<? extends Exception>> communicationExceptions() {
        return Collections.singleton(IOException.class);
    }

    protected boolean isRetriable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        for (Class<? extends Exception> e : this.communicationExceptions()) {
            if (!e.isAssignableFrom(throwable.getClass())) continue;
            return true;
        }
        return this.isRetriable(throwable.getCause());
    }

    protected boolean isCustomRetriable(Throwable throwable) {
        if (!this.connectorConfig.customRetriableException().isPresent()) {
            return false;
        }
        while (throwable != null) {
            if (throwable.getMessage() != null && throwable.getMessage().matches(this.connectorConfig.customRetriableException().get())) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    protected boolean hasMoreRetries() {
        boolean doRetry;
        boolean bl = doRetry = this.unlimitedRetries() || this.retries < this.maxRetries;
        if (doRetry) {
            ++this.retries;
            LOGGER.warn("Retry {} of {} retries will be attempted", (Object)this.retries, this.unlimitedRetries() ? "unlimited" : Integer.valueOf(this.maxRetries));
        } else {
            LOGGER.error("The maximum number of {} retries has been attempted", (Object)this.maxRetries);
        }
        return doRetry;
    }

    private boolean unlimitedRetries() {
        return this.maxRetries == -1;
    }

    public int getRetries() {
        return this.retries;
    }

    public void resetRetries() {
        this.retries = 0;
    }
}

