/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters.recordandmetadata;

import io.debezium.converters.recordandmetadata.RecordAndMetadata;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class RecordAndMetadataBaseImpl
implements RecordAndMetadata {
    private final Struct record;
    protected final Schema dataSchema;

    public RecordAndMetadataBaseImpl(Struct record, Schema dataSchema) {
        this.record = record;
        this.dataSchema = dataSchema;
    }

    @Override
    public Struct record() {
        return this.record;
    }

    @Override
    public Schema dataSchema(String ... dataFields) {
        Struct source = this.record.getStruct("source");
        String connectorType = source.getString("connector");
        return RecordAndMetadataBaseImpl.getDataSchema(this.dataSchema, connectorType, dataFields);
    }

    @Override
    public String id() {
        return null;
    }

    @Override
    public String type() {
        return null;
    }

    @Override
    public Struct source() {
        return this.record.getStruct("source");
    }

    @Override
    public String operation() {
        return this.record.getString("op");
    }

    @Override
    public Struct transaction() {
        return this.record.schema().field("transaction") != null ? this.record.getStruct("transaction") : null;
    }

    @Override
    public SchemaAndValue timestamp() {
        String ts_ms = this.record.getInt64("ts_ms").toString();
        Schema ts_msSchema = this.dataSchema.field("ts_ms").schema();
        return new SchemaAndValue(ts_msSchema, (Object)ts_ms);
    }

    private static Schema getDataSchema(Schema schema, String connectorType, String ... fields) {
        String dataSchemaName = "io.debezium.connector." + connectorType + ".Data";
        SchemaBuilder builder = SchemaBuilder.struct().name(dataSchemaName);
        for (String field : fields) {
            builder.field(field, schema.field(field).schema());
        }
        return builder.build();
    }
}

