/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.config;

import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.data.Envelope;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.heartbeat.HeartbeatConnectionProvider;
import io.debezium.heartbeat.HeartbeatErrorHandler;
import io.debezium.heartbeat.HeartbeatImpl;
import io.debezium.relational.CustomConverterRegistry;
import io.debezium.relational.history.KafkaDatabaseHistory;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.TopicSelector;
import io.debezium.spi.converter.ConvertedField;
import io.debezium.spi.converter.CustomConverter;
import io.debezium.util.SchemaNameAdjuster;
import io.debezium.util.Strings;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonConnectorConfig {
    public static final String TASK_ID = "task.id";
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonConnectorConfig.class);
    private static final String CONFLUENT_AVRO_CONVERTER = "io.confluent.connect.avro.AvroConverter";
    private static final String APICURIO_AVRO_CONVERTER = "io.apicurio.registry.utils.converter.AvroConverter";
    public static final int DEFAULT_MAX_QUEUE_SIZE = 8192;
    public static final int DEFAULT_MAX_BATCH_SIZE = 2048;
    public static final int DEFAULT_QUERY_FETCH_SIZE = 0;
    public static final long DEFAULT_POLL_INTERVAL_MILLIS = 500L;
    public static final String DATABASE_CONFIG_PREFIX = "database.";
    private static final String CONVERTER_TYPE_SUFFIX = ".type";
    public static final long DEFAULT_RETRIABLE_RESTART_WAIT = 10000L;
    public static final long DEFAULT_MAX_QUEUE_SIZE_IN_BYTES = 0L;
    public static final Field RETRIABLE_RESTART_WAIT = Field.create("retriable.restart.connector.wait.ms").withDisplayName("Retriable restart wait (ms)").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry(Field.Group.ADVANCED, 18)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDefault(10000L).withDescription("Time to wait before restarting connector after retriable exception occurs. Defaults to 10000ms.").withValidation(Field::isPositiveLong);
    public static final Field TOMBSTONES_ON_DELETE = Field.create("tombstones.on.delete").withDisplayName("Change the behaviour of Debezium with regards to delete operations").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR, 1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(true).withValidation(Field::isBoolean).withDescription("Whether delete operations should be represented by a delete event and a subsequent tombstone event (true) or only by a delete event (false). Emitting the tombstone event (the default behavior) allows Kafka to completely delete all events pertaining to the given key once the source record got deleted.");
    public static final Field MAX_QUEUE_SIZE = Field.create("max.queue.size").withDisplayName("Change event buffer size").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry(Field.Group.ADVANCED, 15)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Maximum size of the queue for change events read from the database log but not yet recorded or forwarded. Defaults to 8192, and should always be larger than the maximum batch size.").withDefault(8192).withValidation(CommonConnectorConfig::validateMaxQueueSize);
    public static final Field MAX_BATCH_SIZE = Field.create("max.batch.size").withDisplayName("Change event batch size").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry(Field.Group.ADVANCED, 14)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Maximum size of each batch of source records. Defaults to 2048.").withDefault(2048).withValidation(Field::isPositiveInteger);
    public static final Field POLL_INTERVAL_MS = Field.create("poll.interval.ms").withDisplayName("Poll interval (ms)").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry(Field.Group.ADVANCED, 17)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Time to wait for new change events to appear after receiving no events, given in milliseconds. Defaults to 500 ms.").withDefault(500L).withValidation(Field::isPositiveInteger);
    public static final Field MAX_QUEUE_SIZE_IN_BYTES = Field.create("max.queue.size.in.bytes").withDisplayName("Change event buffer size in bytes").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry(Field.Group.ADVANCED, 16)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Maximum size of the queue in bytes for change events read from the database log but not yet recorded or forwarded. Defaults to 0. Mean the feature is not enabled").withDefault(0L).withValidation(Field::isNonNegativeLong);
    public static final Field SNAPSHOT_DELAY_MS = Field.create("snapshot.delay.ms").withDisplayName("Snapshot Delay (milliseconds)").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_SNAPSHOT, 5)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("A delay period before a snapshot will begin, given in milliseconds. Defaults to 0 ms.").withDefault(0L).withValidation(Field::isNonNegativeLong);
    public static final Field SNAPSHOT_FETCH_SIZE = Field.create("snapshot.fetch.size").withDisplayName("Snapshot fetch size").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_SNAPSHOT, 3)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The maximum number of records that should be loaded into memory while performing a snapshot.").withValidation(Field::isNonNegativeInteger);
    public static final Field INCREMENTAL_SNAPSHOT_CHUNK_SIZE = Field.create("incremental.snapshot.chunk.size").withDisplayName("Incremental snapshot chunk size").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The maximum size of chunk for incremental snapshotting").withDefault(1024).withValidation(Field::isNonNegativeInteger);
    public static final Field INCREMENTAL_SNAPSHOT_ALLOW_SCHEMA_CHANGES = Field.create("incremental.snapshot.allow.schema.changes").withDisplayName("Allow schema changes during incremental snapshot if supported.").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Detect schema change during an incremental snapshot and re-select a current chunk to avoid locking DDLs. Note that changes to a primary key are not supported and can cause incorrect results if performed during an incremental snapshot. Another limitation is that if a schema change affects only columns' default values, then the change won't be detected until the DDL is processed from the binlog stream. This doesn't affect the snapshot events' values, but the schema of snapshot events may have outdated defaults.").withDefault(Boolean.FALSE);
    public static final Field SNAPSHOT_MODE_TABLES = Field.create("snapshot.include.collection.list").withDisplayName("Snapshot mode include data collection").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_SNAPSHOT, 2)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(Field::isListOfRegex).withDescription("This setting must be set to specify a list of tables/collections whose snapshot must be taken on creating or restarting the connector.");
    public static final Field SANITIZE_FIELD_NAMES = Field.create("sanitize.field.names").withDisplayName("Sanitize field names to adhere to Avro naming conventions").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_ADVANCED, 18)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Whether field names will be sanitized to Avro naming conventions").withDefault(Boolean.FALSE);
    public static final Field PROVIDE_TRANSACTION_METADATA = Field.create("provide.transaction.metadata").withDisplayName("Store transaction metadata information in a dedicated topic.").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_ADVANCED, 17)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Enables transaction metadata extraction together with event counting").withDefault(Boolean.FALSE);
    public static final Field EVENT_PROCESSING_FAILURE_HANDLING_MODE = Field.create("event.processing.failure.handling.mode").withDisplayName("Event deserialization failure handling").withGroup(Field.createGroupEntry(Field.Group.ADVANCED, 12)).withEnum(EventProcessingFailureHandlingMode.class, EventProcessingFailureHandlingMode.FAIL).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify how failures during processing of events (i.e. when encountering a corrupted event) should be handled, including: 'fail' (the default) an exception indicating the problematic event and its position is raised, causing the connector to be stopped; 'warn' the problematic event and its position will be logged and the event will be skipped; 'ignore' the problematic event will be skipped.");
    public static final Field CUSTOM_CONVERTERS = Field.create("converters").withDisplayName("List of prefixes defining custom values converters.").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_ADVANCED, 10)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("Optional list of custom converters that would be used instead of default ones. The converters are defined using '<converter.prefix>.type' config option and configured using options '<converter.prefix>.<option>'");
    public static final Field SKIPPED_OPERATIONS = Field.create("skipped.operations").withDisplayName("skipped Operations").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry(Field.Group.ADVANCED, 11)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withValidation(CommonConnectorConfig::validateSkippedOperation).withDescription("The comma-separated list of operations to skip during streaming, defined as: 'c' for inserts/create; 'u' for updates; 'd' for deletes, 't' for truncates, and 'none' to indicate nothing skipped. By default, no operations will be skipped.");
    public static final Field BINARY_HANDLING_MODE = Field.create("binary.handling.mode").withDisplayName("Binary Handling").withGroup(Field.createGroupEntry(Field.Group.CONNECTOR, 3)).withEnum(BinaryHandlingMode.class, BinaryHandlingMode.BYTES).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("Specify how binary (blob, binary, etc.) columns should be represented in change events, including: 'bytes' represents binary data as byte array (default); 'base64' represents binary data as base64-encoded string; 'hex' represents binary data as hex-encoded (base16) string");
    public static final Field SCHEMA_NAME_ADJUSTMENT_MODE = Field.create("schema.name.adjustment.mode").withDisplayName("Schema Name Adjustment").withGroup(Field.createGroupEntry(Field.Group.CONNECTOR, 7)).withEnum(SchemaNameAdjustmentMode.class, SchemaNameAdjustmentMode.AVRO).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("Specify how schema names should be adjusted for compatibility with the message converter used by the connector, including: 'avro' replaces the characters that cannot be used in the Avro type name with underscore (default); 'none' does not apply any adjustment");
    public static final Field QUERY_FETCH_SIZE = Field.create("query.fetch.size").withDisplayName("Query fetch size").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry(Field.Group.ADVANCED, 13)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The maximum number of records that should be loaded into memory while streaming. A value of '0' uses the default JDBC fetch size.").withValidation(Field::isNonNegativeInteger).withDefault(0);
    public static final Field SNAPSHOT_MAX_THREADS = Field.create("snapshot.max.threads").withDisplayName("Snapshot maximum threads").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_SNAPSHOT, 7)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(1).withValidation(Field::isPositiveInteger).withDescription("The maximum number of threads used to perform the snapshot. Defaults to 1.");
    public static final Field SIGNAL_DATA_COLLECTION = Field.create("signal.data.collection").withDisplayName("Signaling data collection").withGroup(Field.createGroupEntry(Field.Group.ADVANCED, 20)).withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The name of the data collection that is used to send signals/commands to Debezium. Signaling is disabled when not set.");
    public static final Field TRANSACTION_TOPIC = Field.create("transaction.topic").withDisplayName("Transaction topic name").withGroup(Field.createGroupEntry(Field.Group.ADVANCED, 21)).withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDefault("${database.server.name}.transaction").withDescription("The name of the transaction metadata topic. The placeholder ${database.server.name} can be used for referring to the connector's logical name; defaults to ${database.server.name}.transaction.");
    public static final Field CUSTOM_RETRIABLE_EXCEPTION = Field.createInternal("custom.retriable.exception").withDisplayName("Regular expression to match the exception message.").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_ADVANCED, 999)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("Provide a temporary workaround for an error that should be retriable. If set a stacktrace of non-retriable exception is traversed and messages are matched against this regular expression. If matched the error is changed to retriable.").withDefault(false);
    protected static final ConfigDefinition CONFIG_DEFINITION = ConfigDefinition.editor().connector(EVENT_PROCESSING_FAILURE_HANDLING_MODE, MAX_BATCH_SIZE, MAX_QUEUE_SIZE, POLL_INTERVAL_MS, MAX_QUEUE_SIZE_IN_BYTES, PROVIDE_TRANSACTION_METADATA, SKIPPED_OPERATIONS, SNAPSHOT_DELAY_MS, SNAPSHOT_MODE_TABLES, SNAPSHOT_FETCH_SIZE, SNAPSHOT_MAX_THREADS, RETRIABLE_RESTART_WAIT, QUERY_FETCH_SIZE).events(CUSTOM_CONVERTERS, SANITIZE_FIELD_NAMES, TOMBSTONES_ON_DELETE, Heartbeat.HEARTBEAT_INTERVAL, Heartbeat.HEARTBEAT_TOPICS_PREFIX, SIGNAL_DATA_COLLECTION, TRANSACTION_TOPIC).create();
    private final Configuration config;
    private final boolean emitTombstoneOnDelete;
    private final int maxQueueSize;
    private final int maxBatchSize;
    private final long maxQueueSizeInBytes;
    private final Duration pollInterval;
    private final String logicalName;
    private final String heartbeatTopicsPrefix;
    private final Duration heartbeatInterval;
    private final Duration snapshotDelay;
    private final Duration retriableRestartWait;
    private final int snapshotFetchSize;
    private final int incrementalSnapshotChunkSize;
    private final boolean incrementalSnapshotAllowSchemaChanges;
    private final int snapshotMaxThreads;
    private final Integer queryFetchSize;
    private final SourceInfoStructMaker<? extends AbstractSourceInfo> sourceInfoStructMaker;
    private final boolean sanitizeFieldNames;
    private final boolean shouldProvideTransactionMetadata;
    private final EventProcessingFailureHandlingMode eventProcessingFailureHandlingMode;
    private final CustomConverterRegistry customConverterRegistry;
    private final BinaryHandlingMode binaryHandlingMode;
    private final SchemaNameAdjustmentMode schemaNameAdjustmentMode;
    private final String signalingDataCollection;
    private final EnumSet<Envelope.Operation> skippedOperations;
    private final String transactionTopic;
    private final String taskId;

    protected CommonConnectorConfig(Configuration config, String logicalName, int defaultSnapshotFetchSize) {
        this.config = config;
        this.emitTombstoneOnDelete = config.getBoolean(TOMBSTONES_ON_DELETE);
        this.maxQueueSize = config.getInteger(MAX_QUEUE_SIZE);
        this.maxBatchSize = config.getInteger(MAX_BATCH_SIZE);
        this.pollInterval = config.getDuration(POLL_INTERVAL_MS, ChronoUnit.MILLIS);
        this.maxQueueSizeInBytes = config.getLong(MAX_QUEUE_SIZE_IN_BYTES);
        this.logicalName = logicalName;
        this.heartbeatTopicsPrefix = config.getString(Heartbeat.HEARTBEAT_TOPICS_PREFIX);
        this.heartbeatInterval = config.getDuration(Heartbeat.HEARTBEAT_INTERVAL, ChronoUnit.MILLIS);
        this.snapshotDelay = Duration.ofMillis(config.getLong(SNAPSHOT_DELAY_MS));
        this.retriableRestartWait = Duration.ofMillis(config.getLong(RETRIABLE_RESTART_WAIT));
        this.snapshotFetchSize = config.getInteger(SNAPSHOT_FETCH_SIZE, defaultSnapshotFetchSize);
        this.snapshotMaxThreads = config.getInteger(SNAPSHOT_MAX_THREADS);
        this.queryFetchSize = config.getInteger(QUERY_FETCH_SIZE);
        this.incrementalSnapshotChunkSize = config.getInteger(INCREMENTAL_SNAPSHOT_CHUNK_SIZE);
        this.incrementalSnapshotAllowSchemaChanges = config.getBoolean(INCREMENTAL_SNAPSHOT_ALLOW_SCHEMA_CHANGES);
        this.schemaNameAdjustmentMode = SchemaNameAdjustmentMode.parse(config.getString(SCHEMA_NAME_ADJUSTMENT_MODE));
        this.sourceInfoStructMaker = this.getSourceInfoStructMaker(Version.V2);
        this.sanitizeFieldNames = config.getBoolean(SANITIZE_FIELD_NAMES) || CommonConnectorConfig.isUsingAvroConverter(config);
        this.shouldProvideTransactionMetadata = config.getBoolean(PROVIDE_TRANSACTION_METADATA);
        this.eventProcessingFailureHandlingMode = EventProcessingFailureHandlingMode.parse(config.getString(EVENT_PROCESSING_FAILURE_HANDLING_MODE));
        this.customConverterRegistry = new CustomConverterRegistry(this.getCustomConverters());
        this.binaryHandlingMode = BinaryHandlingMode.parse(config.getString(BINARY_HANDLING_MODE));
        this.signalingDataCollection = config.getString(SIGNAL_DATA_COLLECTION);
        this.skippedOperations = CommonConnectorConfig.determineSkippedOperations(config);
        this.transactionTopic = config.getString(TRANSACTION_TOPIC).replace("${database.server.name}", logicalName);
        this.taskId = config.getString(TASK_ID);
    }

    private static EnumSet<Envelope.Operation> determineSkippedOperations(Configuration config) {
        String operations = config.getString(SKIPPED_OPERATIONS);
        if (operations != null) {
            if (operations.trim().equalsIgnoreCase("none")) {
                return EnumSet.noneOf(Envelope.Operation.class);
            }
            return EnumSet.copyOf(Arrays.stream(operations.split(",")).map(String::trim).map(Envelope.Operation::forCode).collect(Collectors.toSet()));
        }
        return EnumSet.noneOf(Envelope.Operation.class);
    }

    @Deprecated
    public Configuration getConfig() {
        return this.config;
    }

    public boolean isEmitTombstoneOnDelete() {
        return this.emitTombstoneOnDelete;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public long getMaxQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public Duration getPollInterval() {
        return this.pollInterval;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public abstract String getContextName();

    public abstract String getConnectorName();

    public String getHeartbeatTopicsPrefix() {
        return this.heartbeatTopicsPrefix;
    }

    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public Duration getRetriableRestartWait() {
        return this.retriableRestartWait;
    }

    public Duration getSnapshotDelay() {
        return this.snapshotDelay;
    }

    public int getSnapshotFetchSize() {
        return this.snapshotFetchSize;
    }

    public int getSnapshotMaxThreads() {
        return this.snapshotMaxThreads;
    }

    public int getQueryFetchSize() {
        return this.queryFetchSize;
    }

    public int getIncrementalSnashotChunkSize() {
        return this.incrementalSnapshotChunkSize;
    }

    public boolean shouldProvideTransactionMetadata() {
        return this.shouldProvideTransactionMetadata;
    }

    public EventProcessingFailureHandlingMode getEventProcessingFailureHandlingMode() {
        return this.eventProcessingFailureHandlingMode;
    }

    public CustomConverterRegistry customConverterRegistry() {
        return this.customConverterRegistry;
    }

    public String getTransactionTopic() {
        return this.transactionTopic;
    }

    public boolean supportsOperationFiltering() {
        return false;
    }

    protected boolean supportsSchemaChangesDuringIncrementalSnapshot() {
        return false;
    }

    public boolean isIncrementalSnapshotSchemaChangesEnabled() {
        return this.supportsSchemaChangesDuringIncrementalSnapshot() && this.incrementalSnapshotAllowSchemaChanges;
    }

    private List<CustomConverter<SchemaBuilder, ConvertedField>> getCustomConverters() {
        String converterNameList = this.config.getString(CUSTOM_CONVERTERS);
        List<String> converterNames = Strings.listOf(converterNameList, x -> x.split(","), String::trim);
        return converterNames.stream().map(name -> {
            CustomConverter converter = this.config.getInstance(name + CONVERTER_TYPE_SUFFIX, CustomConverter.class);
            converter.configure(this.config.subset((String)name, true).asProperties());
            return converter;
        }).collect(Collectors.toList());
    }

    public <T extends AbstractSourceInfo> SourceInfoStructMaker<T> getSourceInfoStructMaker() {
        return this.sourceInfoStructMaker;
    }

    public boolean getSanitizeFieldNames() {
        return this.sanitizeFieldNames;
    }

    public EnumSet<Envelope.Operation> getSkippedOperations() {
        return this.skippedOperations;
    }

    @Deprecated
    public Set<String> legacyGetDataCollectionsToBeSnapshotted() {
        return Optional.ofNullable(this.config.getString(SNAPSHOT_MODE_TABLES)).map(tables -> Strings.setOf(tables, Function.identity())).orElseGet(Collections::emptySet);
    }

    public Set<Pattern> getDataCollectionsToBeSnapshotted() {
        return Optional.ofNullable(this.config.getString(SNAPSHOT_MODE_TABLES)).map(tables -> Strings.setOfRegex(tables, 2)).orElseGet(Collections::emptySet);
    }

    public boolean isSchemaChangesHistoryEnabled() {
        return false;
    }

    public boolean isSchemaCommentsHistoryEnabled() {
        return false;
    }

    public boolean validate(Iterable<Field> fields, Field.ValidationOutput problems) {
        return this.config.validate(fields, problems);
    }

    public boolean validateAndRecord(Iterable<Field> fields, Consumer<String> problems) {
        return this.config.validateAndRecord(fields, problems);
    }

    private static int validateMaxQueueSize(Configuration config, Field field, Field.ValidationOutput problems) {
        int maxQueueSize = config.getInteger(field);
        int maxBatchSize = config.getInteger(MAX_BATCH_SIZE);
        int count = 0;
        if (maxQueueSize <= 0) {
            problems.accept(field, maxQueueSize, "A positive queue size is required");
            ++count;
        }
        if (maxQueueSize <= maxBatchSize) {
            problems.accept(field, maxQueueSize, "Must be larger than the maximum batch size");
            ++count;
        }
        return count;
    }

    protected static int validateSkippedOperation(Configuration config, Field field, Field.ValidationOutput problems) {
        String operations = config.getString(field);
        if (operations == null || "none".equals(operations)) {
            return 0;
        }
        boolean noneSpecified = false;
        boolean operationsSpecified = false;
        block12: for (String operation : operations.split(",")) {
            switch (operation.trim()) {
                case "none": {
                    noneSpecified = true;
                    continue block12;
                }
                case "r": 
                case "c": 
                case "u": 
                case "d": 
                case "t": {
                    operationsSpecified = true;
                    continue block12;
                }
                default: {
                    problems.accept(field, operation, "Invalid operation");
                    return 1;
                }
            }
        }
        if (noneSpecified && operationsSpecified) {
            problems.accept(field, "none", "'none' cannot be specified with other skipped operation types");
            return 1;
        }
        return 0;
    }

    private static boolean isUsingAvroConverter(Configuration config) {
        String keyConverter = config.getString("key.converter");
        String valueConverter = config.getString("value.converter");
        return CONFLUENT_AVRO_CONVERTER.equals(keyConverter) || CONFLUENT_AVRO_CONVERTER.equals(valueConverter) || APICURIO_AVRO_CONVERTER.equals(keyConverter) || APICURIO_AVRO_CONVERTER.equals(valueConverter);
    }

    public static int validateServerNameIsDifferentFromHistoryTopicName(Configuration config, Field field, Field.ValidationOutput problems) {
        String historyTopicName;
        String serverName = config.getString(field);
        if (Objects.equals(serverName, historyTopicName = config.getString(KafkaDatabaseHistory.TOPIC))) {
            problems.accept(field, serverName, "Must not have the same value as " + KafkaDatabaseHistory.TOPIC.name());
            return 1;
        }
        return 0;
    }

    protected abstract SourceInfoStructMaker<?> getSourceInfoStructMaker(Version var1);

    public BinaryHandlingMode binaryHandlingMode() {
        return this.binaryHandlingMode;
    }

    public SchemaNameAdjustmentMode schemaNameAdjustmentMode() {
        return this.schemaNameAdjustmentMode;
    }

    public String getSignalingDataCollectionId() {
        return this.signalingDataCollection;
    }

    public Optional<String[]> parseSignallingMessage(Struct value) {
        Struct after = value.getStruct("after");
        if (after == null) {
            LOGGER.warn("After part of signal '{}' is missing", (Object)value);
            return Optional.empty();
        }
        List fields = after.schema().fields();
        if (fields.size() != 3) {
            LOGGER.warn("The signal event '{}' should have 3 fields but has {}", (Object)after, (Object)fields.size());
            return Optional.empty();
        }
        return Optional.of(new String[]{after.getString(((org.apache.kafka.connect.data.Field)fields.get(0)).name()), after.getString(((org.apache.kafka.connect.data.Field)fields.get(1)).name()), after.getString(((org.apache.kafka.connect.data.Field)fields.get(2)).name())});
    }

    public boolean isSignalDataCollection(DataCollectionId dataCollectionId) {
        return this.signalingDataCollection != null && this.signalingDataCollection.equals(dataCollectionId.identifier());
    }

    public Optional<String> customRetriableException() {
        return Optional.ofNullable(this.config.getString(CUSTOM_RETRIABLE_EXCEPTION));
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Heartbeat createHeartbeat(TopicSelector<? extends DataCollectionId> topicSelector, SchemaNameAdjuster schemaNameAdjuster, HeartbeatConnectionProvider connectionProvider, HeartbeatErrorHandler errorHandler) {
        if (this.getHeartbeatInterval().isZero()) {
            return Heartbeat.DEFAULT_NOOP_HEARTBEAT;
        }
        return new HeartbeatImpl(this.getHeartbeatInterval(), topicSelector.getHeartbeatTopic(), this.getLogicalName(), schemaNameAdjuster);
    }

    public static enum SchemaNameAdjustmentMode implements EnumeratedValue
    {
        NONE("none"),
        AVRO("avro");

        private final String value;

        private SchemaNameAdjustmentMode(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public SchemaNameAdjuster createAdjuster() {
            if (this == AVRO) {
                return SchemaNameAdjuster.create();
            }
            return SchemaNameAdjuster.NO_OP;
        }

        public static SchemaNameAdjustmentMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SchemaNameAdjustmentMode option : SchemaNameAdjustmentMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }
    }

    public static enum Version implements EnumeratedValue
    {
        V1("v1"),
        V2("v2");

        private final String value;

        private Version(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static Version parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (Version option : Version.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static Version parse(String value, String defaultValue) {
            Version mode = Version.parse(value);
            if (mode == null && defaultValue != null) {
                mode = Version.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum EventProcessingFailureHandlingMode implements EnumeratedValue
    {
        SKIP("skip"),
        WARN("warn"),
        FAIL("fail"),
        IGNORE("ignore");

        private final String value;

        private EventProcessingFailureHandlingMode(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static EventProcessingFailureHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (EventProcessingFailureHandlingMode option : EventProcessingFailureHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }
    }

    public static enum BinaryHandlingMode implements EnumeratedValue
    {
        BYTES("bytes", SchemaBuilder::bytes),
        BASE64("base64", SchemaBuilder::string),
        HEX("hex", SchemaBuilder::string);

        private final String value;
        private final Supplier<SchemaBuilder> schema;

        private BinaryHandlingMode(String value, Supplier<SchemaBuilder> schema) {
            this.value = value;
            this.schema = schema;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public SchemaBuilder getSchema() {
            return this.schema.get();
        }

        public static BinaryHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (BinaryHandlingMode option : BinaryHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static BinaryHandlingMode parse(String value, String defaultValue) {
            BinaryHandlingMode mode = BinaryHandlingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = BinaryHandlingMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

