/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.ColumnEditorImpl;
import java.util.List;
import java.util.Optional;

@Immutable
public interface Column
extends Comparable<Column> {
    public static final int UNSET_INT_VALUE = -1;

    public static ColumnEditor editor() {
        return new ColumnEditorImpl();
    }

    public String name();

    public int position();

    public int jdbcType();

    public int nativeType();

    public String typeName();

    public String typeExpression();

    public String charsetName();

    public int length();

    public Optional<Integer> scale();

    public boolean isOptional();

    default public boolean isRequired() {
        return !this.isOptional();
    }

    public boolean isAutoIncremented();

    public boolean isGenerated();

    public Object defaultValue();

    public boolean hasDefaultValue();

    public List<String> enumValues();

    @Override
    default public int compareTo(Column that) {
        if (this == that) {
            return 0;
        }
        return this.position() - that.position();
    }

    public ColumnEditor edit();

    default public boolean typeUsesCharset() {
        switch (this.jdbcType()) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 70: 
            case 2005: 
            case 2009: 
            case 2011: {
                return true;
            }
        }
        return false;
    }
}

