/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source.snapshot.incremental;

import io.debezium.DebeziumException;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.Column;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.SnapshotChangeRecordEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.util.Clock;
import io.debezium.util.ColumnUtils;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SignalBasedIncrementalSnapshotChangeEventSource<T extends DataCollectionId>
implements IncrementalSnapshotChangeEventSource<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignalBasedIncrementalSnapshotChangeEventSource.class);
    private Map<Struct, Object[]> window = new LinkedHashMap<Struct, Object[]>();
    private CommonConnectorConfig connectorConfig;
    private JdbcConnection jdbcConnection;
    private final Clock clock;
    private final String signalWindowStatement;
    private final RelationalDatabaseSchema databaseSchema;
    private final SnapshotProgressListener progressListener;
    private final DataChangeEventListener dataListener;
    private long totalRowsScanned = 0L;
    private Table currentTable;
    private IncrementalSnapshotContext<T> context = null;

    public SignalBasedIncrementalSnapshotChangeEventSource(CommonConnectorConfig config, JdbcConnection jdbcConnection, DatabaseSchema<?> databaseSchema, Clock clock, SnapshotProgressListener progressListener, DataChangeEventListener dataChangeEventListener) {
        this.connectorConfig = config;
        this.jdbcConnection = jdbcConnection;
        this.signalWindowStatement = "INSERT INTO " + this.connectorConfig.getSignalingDataCollectionId() + " VALUES (?, ?, null)";
        this.databaseSchema = (RelationalDatabaseSchema)databaseSchema;
        this.clock = clock;
        this.progressListener = progressListener;
        this.dataListener = dataChangeEventListener;
    }

    @Override
    public void closeWindow(String id, EventDispatcher<T> dispatcher, OffsetContext offsetContext) throws InterruptedException {
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (!this.context.closeWindow(id)) {
            return;
        }
        LOGGER.debug("Sending {} events from window buffer", (Object)this.window.size());
        offsetContext.incrementalSnapshotEvents();
        for (Object[] row : this.window.values()) {
            this.sendEvent(dispatcher, offsetContext, row);
        }
        offsetContext.postSnapshotCompletion();
        this.window.clear();
        this.readChunk();
    }

    protected void sendEvent(EventDispatcher<T> dispatcher, OffsetContext offsetContext, Object[] row) throws InterruptedException {
        this.context.sendEvent(this.keyFromRow(row));
        offsetContext.event((DataCollectionId)this.context.currentDataCollectionId(), this.clock.currentTimeAsInstant());
        dispatcher.dispatchSnapshotEvent((DataCollectionId)this.context.currentDataCollectionId(), this.getChangeRecordEmitter((DataCollectionId)this.context.currentDataCollectionId(), offsetContext, row), dispatcher.getIncrementalSnapshotChangeEventReceiver(this.dataListener));
    }

    protected ChangeRecordEmitter getChangeRecordEmitter(T dataCollectionId, OffsetContext offsetContext, Object[] row) {
        return new SnapshotChangeRecordEmitter(offsetContext, row, this.clock);
    }

    @Override
    public void processMessage(DataCollectionId dataCollectionId, Object key, OffsetContext offsetContext) {
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (this.context == null) {
            return;
        }
        LOGGER.trace("Checking window for table '{}', key '{}', window contains '{}'", new Object[]{dataCollectionId, key, this.window});
        if (!this.context.deduplicationNeeded() || this.window.isEmpty()) {
            return;
        }
        if (!((DataCollectionId)this.context.currentDataCollectionId()).equals(dataCollectionId)) {
            return;
        }
        if (key instanceof Struct && this.window.remove((Struct)key) != null) {
            LOGGER.info("Removed '{}' from window", key);
        }
    }

    private void emitWindowOpen() throws SQLException {
        this.jdbcConnection.prepareUpdate(this.signalWindowStatement, x -> {
            x.setString(1, this.context.currentChunkId() + "-open");
            x.setString(2, "snapshot-window-open");
        });
    }

    private void emitWindowClose() throws SQLException {
        this.jdbcConnection.prepareUpdate(this.signalWindowStatement, x -> {
            x.setString(1, this.context.currentChunkId() + "-close");
            x.setString(2, "snapshot-window-close");
        });
    }

    protected String buildChunkQuery(Table table) {
        String condition = null;
        if (this.context.isNonInitialChunk()) {
            StringBuilder sql = new StringBuilder();
            this.addKeyColumnsToCondition(table, sql, " >= ?");
            sql.append(" AND NOT (");
            this.addKeyColumnsToCondition(table, sql, " = ?");
            sql.append(")");
            sql.append(" AND ");
            this.addKeyColumnsToCondition(table, sql, " <= ?");
            condition = sql.toString();
        }
        String orderBy = table.primaryKeyColumns().stream().map(Column::name).collect(Collectors.joining(", "));
        return this.jdbcConnection.buildSelectWithRowLimits(table.id(), this.connectorConfig.getIncrementalSnashotChunkSize(), "*", Optional.ofNullable(condition), orderBy);
    }

    protected String buildMaxPrimaryKeyQuery(Table table) {
        String orderBy = table.primaryKeyColumns().stream().map(Column::name).collect(Collectors.joining(" DESC, ")) + " DESC";
        return this.jdbcConnection.buildSelectWithRowLimits(table.id(), 1, "*", Optional.empty(), orderBy.toString());
    }

    @Override
    public void init(OffsetContext offsetContext) {
        if (offsetContext == null) {
            LOGGER.info("Empty incremental snapshot change event source started, no action needed");
            return;
        }
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (!this.context.snapshotRunning()) {
            LOGGER.info("No incremental snapshot in progress, no action needed on start");
            return;
        }
        LOGGER.info("Incremental snapshot in progress, need to read new chunk on start");
        try {
            this.progressListener.snapshotStarted();
            this.readChunk();
        }
        catch (InterruptedException e) {
            throw new DebeziumException("Reading of an initial chunk after connector restart has been interrupted");
        }
        LOGGER.info("Incremental snapshot in progress, loading of initial chunk completed");
    }

    private void readChunk() throws InterruptedException {
        if (!this.context.snapshotRunning()) {
            return;
        }
        try {
            this.jdbcConnection.commit();
            this.context.startNewChunk();
            this.emitWindowOpen();
            this.jdbcConnection.commit();
            while (this.context.snapshotRunning()) {
                TableId currentTableId = (TableId)this.context.currentDataCollectionId();
                this.currentTable = this.databaseSchema.tableFor(currentTableId);
                if (this.currentTable == null) break;
                if (!this.context.maximumKey().isPresent()) {
                    this.context.maximumKey(this.jdbcConnection.queryAndMap(this.buildMaxPrimaryKeyQuery(this.currentTable), rs -> {
                        if (!rs.next()) {
                            return null;
                        }
                        return this.keyFromRow(this.jdbcConnection.rowToArray(this.currentTable, this.databaseSchema, rs, ColumnUtils.toArray(rs, this.currentTable)));
                    }));
                    if (!this.context.maximumKey().isPresent()) {
                        LOGGER.info("No maximum key returned by the query, incremental snapshotting of table '{}' finished as it is empty", (Object)currentTableId);
                        this.context.nextDataCollection();
                        continue;
                    }
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Incremental snapshot for table '{}' will end at position {}", (Object)currentTableId, (Object)this.context.maximumKey().orElse(new Object[0]));
                    }
                }
                this.createDataEventsForTable();
                if (!this.window.isEmpty()) break;
                LOGGER.info("No data returned by the query, incremental snapshotting of table '{}' finished", (Object)currentTableId);
                this.tableScanCompleted();
                this.context.nextDataCollection();
                if (this.context.snapshotRunning()) continue;
                this.progressListener.snapshotCompleted();
            }
            this.emitWindowClose();
            this.jdbcConnection.commit();
        }
        catch (SQLException e) {
            throw new DebeziumException("Database error while executing incremental snapshot", (Throwable)e);
        }
    }

    @Override
    public void addDataCollectionNamesToSnapshot(List<String> dataCollectionIds, OffsetContext offsetContext) throws InterruptedException {
        this.context = offsetContext.getIncrementalSnapshotContext();
        boolean shouldReadChunk = false;
        if (!this.context.snapshotRunning()) {
            shouldReadChunk = true;
        }
        List<T> newDataCollectionIds = this.context.addDataCollectionNamesToSnapshot(dataCollectionIds);
        if (shouldReadChunk) {
            this.progressListener.snapshotStarted();
            this.progressListener.monitoredDataCollectionsDetermined(newDataCollectionIds);
            this.readChunk();
        }
    }

    protected void addKeyColumnsToCondition(Table table, StringBuilder sql, String predicate) {
        Iterator<Column> i = table.primaryKeyColumns().iterator();
        while (i.hasNext()) {
            Column key = i.next();
            sql.append(key.name()).append(predicate);
            if (!i.hasNext()) continue;
            sql.append(" AND ");
        }
    }

    private void createDataEventsForTable() throws InterruptedException {
        long exportStart = this.clock.currentTimeInMillis();
        LOGGER.debug("Exporting data chunk from table '{}' (total {} tables)", (Object)this.currentTable.id(), (Object)this.context.tablesToBeSnapshottedCount());
        String selectStatement = this.buildChunkQuery(this.currentTable);
        LOGGER.debug("\t For table '{}' using select statement: '{}', key: '{}', maximum key: '{}'", new Object[]{this.currentTable.id(), selectStatement, this.context.chunkEndPosititon(), this.context.maximumKey().get()});
        TableSchema tableSchema = this.databaseSchema.schemaFor(this.currentTable.id());
        try (PreparedStatement statement = this.readTableChunkStatement(selectStatement);
             ResultSet rs = statement.executeQuery();){
            ColumnUtils.ColumnArray columnArray = ColumnUtils.toArray(rs, this.currentTable);
            long rows = 0L;
            Threads.Timer logTimer = this.getTableScanLogTimer();
            Object[] lastRow = null;
            Object[] firstRow = null;
            while (rs.next()) {
                ++rows;
                Object[] row = this.jdbcConnection.rowToArray(this.currentTable, this.databaseSchema, rs, columnArray);
                if (firstRow == null) {
                    firstRow = row;
                }
                Struct keyStruct = tableSchema.keyFromColumnData(row);
                this.window.put(keyStruct, row);
                if (logTimer.expired()) {
                    long stop = this.clock.currentTimeInMillis();
                    LOGGER.debug("\t Exported {} records for table '{}' after {}", new Object[]{rows, this.currentTable.id(), Strings.duration(stop - exportStart)});
                    logTimer = this.getTableScanLogTimer();
                }
                lastRow = row;
            }
            Object[] firstKey = this.keyFromRow(firstRow);
            Object[] lastKey = this.keyFromRow(lastRow);
            this.context.nextChunkPosition(lastKey);
            this.progressListener.currentChunk(this.context.currentChunkId(), firstKey, lastKey);
            if (lastRow != null) {
                LOGGER.debug("\t Next window will resume from '{}'", this.context.chunkEndPosititon());
            }
            LOGGER.debug("\t Finished exporting {} records for window of table table '{}'; total duration '{}'", new Object[]{rows, this.currentTable.id(), Strings.duration(this.clock.currentTimeInMillis() - exportStart)});
            this.incrementTableRowsScanned(rows);
        }
        catch (SQLException e) {
            throw new DebeziumException("Snapshotting of table " + this.currentTable.id() + " failed", (Throwable)e);
        }
    }

    private void incrementTableRowsScanned(long rows) {
        this.totalRowsScanned += rows;
        this.progressListener.rowsScanned(this.currentTable.id(), this.totalRowsScanned);
    }

    private void tableScanCompleted() {
        this.progressListener.dataCollectionSnapshotCompleted(this.currentTable.id(), this.totalRowsScanned);
        this.totalRowsScanned = 0L;
    }

    protected PreparedStatement readTableChunkStatement(String sql) throws SQLException {
        PreparedStatement statement = this.jdbcConnection.readTablePreparedStatement(this.connectorConfig, sql, OptionalLong.empty());
        if (this.context.isNonInitialChunk()) {
            Object[] maximumKey = this.context.maximumKey().get();
            Object[] chunkEndPosition = this.context.chunkEndPosititon();
            for (int i = 0; i < chunkEndPosition.length; ++i) {
                statement.setObject(i + 1, chunkEndPosition[i]);
                statement.setObject(i + 1 + chunkEndPosition.length, chunkEndPosition[i]);
                statement.setObject(i + 1 + 2 * chunkEndPosition.length, maximumKey[i]);
            }
        }
        return statement;
    }

    private Threads.Timer getTableScanLogTimer() {
        return Threads.timer(this.clock, RelationalSnapshotChangeEventSource.LOG_INTERVAL);
    }

    private Object[] keyFromRow(Object[] row) {
        if (row == null) {
            return null;
        }
        List<Column> keyColumns = this.currentTable.primaryKeyColumns();
        Object[] key = new Object[keyColumns.size()];
        for (int i = 0; i < keyColumns.size(); ++i) {
            key[i] = row[keyColumns.get(i).position() - 1];
        }
        return key;
    }

    protected void setContext(IncrementalSnapshotContext<T> context) {
        this.context = context;
    }
}

