/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.ddl;

import io.debezium.annotation.Immutable;
import io.debezium.relational.TableId;
import java.util.Optional;

@FunctionalInterface
public interface DdlParserListener {
    public void handle(Event var1);

    @Immutable
    public static class SetVariableEvent
    extends Event {
        private final String variableName;
        private final String value;
        private final String databaseName;

        public SetVariableEvent(String variableName, String value, String currentDatabaseName, String ddlStatement) {
            super(EventType.SET_VARIABLE, ddlStatement);
            this.variableName = variableName;
            this.value = value;
            this.databaseName = currentDatabaseName;
        }

        public String variableName() {
            return this.variableName;
        }

        public String variableValue() {
            return this.value;
        }

        public Optional<String> databaseName() {
            return Optional.ofNullable(this.databaseName);
        }

        public String toString() {
            return this.statement();
        }
    }

    @Immutable
    public static class DatabaseSwitchedEvent
    extends DatabaseEvent {
        public DatabaseSwitchedEvent(String databaseName, String ddlStatement) {
            super(EventType.USE_DATABASE, databaseName, ddlStatement);
        }
    }

    @Immutable
    public static class DatabaseDroppedEvent
    extends DatabaseEvent {
        public DatabaseDroppedEvent(String databaseName, String ddlStatement) {
            super(EventType.DROP_DATABASE, databaseName, ddlStatement);
        }
    }

    @Immutable
    public static class DatabaseAlteredEvent
    extends DatabaseEvent {
        private final String previousDatabaseName;

        public DatabaseAlteredEvent(String databaseName, String previousDatabaseName, String ddlStatement) {
            super(EventType.ALTER_DATABASE, databaseName, ddlStatement);
            this.previousDatabaseName = previousDatabaseName;
        }

        public String previousDatabaseName() {
            return this.previousDatabaseName;
        }

        @Override
        public String toString() {
            if (this.previousDatabaseName != null) {
                return this.databaseName() + " (was " + this.previousDatabaseName() + ") => " + this.statement();
            }
            return this.databaseName() + " => " + this.statement();
        }
    }

    @Immutable
    public static class DatabaseCreatedEvent
    extends DatabaseEvent {
        public DatabaseCreatedEvent(String databaseName, String ddlStatement) {
            super(EventType.CREATE_DATABASE, databaseName, ddlStatement);
        }
    }

    @Immutable
    public static abstract class DatabaseEvent
    extends Event {
        private final String databaseName;

        public DatabaseEvent(EventType type, String databaseName, String ddlStatement) {
            super(type, ddlStatement);
            this.databaseName = databaseName;
        }

        public String databaseName() {
            return this.databaseName;
        }

        public String toString() {
            return this.databaseName() + " => " + this.statement();
        }
    }

    @Immutable
    public static class TableIndexDroppedEvent
    extends TableIndexEvent {
        public TableIndexDroppedEvent(String indexName, TableId tableId, String ddlStatement) {
            super(EventType.DROP_INDEX, indexName, tableId, ddlStatement);
        }
    }

    @Immutable
    public static class TableIndexCreatedEvent
    extends TableIndexEvent {
        public TableIndexCreatedEvent(String indexName, TableId tableId, String ddlStatement) {
            super(EventType.CREATE_INDEX, indexName, tableId, ddlStatement);
        }
    }

    @Immutable
    public static abstract class TableIndexEvent
    extends Event {
        private final TableId tableId;
        private final String indexName;

        public TableIndexEvent(EventType type, String indexName, TableId tableId, String ddlStatement) {
            super(type, ddlStatement);
            this.tableId = tableId;
            this.indexName = indexName;
        }

        public TableId tableId() {
            return this.tableId;
        }

        public String indexName() {
            return this.indexName;
        }

        public String toString() {
            if (this.tableId == null) {
                return this.indexName() + " => " + this.statement();
            }
            return this.indexName() + " on " + this.tableId() + " => " + this.statement();
        }
    }

    @Immutable
    public static class TableTruncatedEvent
    extends TableEvent {
        public TableTruncatedEvent(TableId tableId, String ddlStatement, boolean isView) {
            super(EventType.TRUNCATE_TABLE, tableId, ddlStatement, isView);
        }
    }

    @Immutable
    public static class TableDroppedEvent
    extends TableEvent {
        public TableDroppedEvent(TableId tableId, String ddlStatement, boolean isView) {
            super(EventType.DROP_TABLE, tableId, ddlStatement, isView);
        }
    }

    @Immutable
    public static class TableAlteredEvent
    extends TableEvent {
        private final TableId previousTableId;

        public TableAlteredEvent(TableId tableId, TableId previousTableId, String ddlStatement, boolean isView) {
            super(EventType.ALTER_TABLE, tableId, ddlStatement, isView);
            this.previousTableId = previousTableId;
        }

        public TableId previousTableId() {
            return this.previousTableId;
        }

        @Override
        public String toString() {
            if (this.previousTableId != null) {
                return this.tableId() + " (was " + this.previousTableId() + ") => " + this.statement();
            }
            return this.tableId() + " => " + this.statement();
        }
    }

    @Immutable
    public static class TableCreatedEvent
    extends TableEvent {
        public TableCreatedEvent(TableId tableId, String ddlStatement, boolean isView) {
            super(EventType.CREATE_TABLE, tableId, ddlStatement, isView);
        }
    }

    @Immutable
    public static abstract class TableEvent
    extends Event {
        private final TableId tableId;
        private final boolean isView;

        public TableEvent(EventType type, TableId tableId, String ddlStatement, boolean isView) {
            super(type, ddlStatement);
            this.tableId = tableId;
            this.isView = isView;
        }

        public TableId tableId() {
            return this.tableId;
        }

        public boolean isView() {
            return this.isView;
        }

        public String toString() {
            return this.tableId() + " => " + this.statement();
        }
    }

    @Immutable
    public static abstract class Event {
        private final String statement;
        private final EventType type;

        public Event(EventType type, String ddlStatement) {
            this.type = type;
            this.statement = ddlStatement;
        }

        public EventType type() {
            return this.type;
        }

        public String statement() {
            return this.statement;
        }
    }

    public static enum EventType {
        CREATE_TABLE,
        ALTER_TABLE,
        DROP_TABLE,
        TRUNCATE_TABLE,
        CREATE_INDEX,
        DROP_INDEX,
        CREATE_DATABASE,
        ALTER_DATABASE,
        DROP_DATABASE,
        USE_DATABASE,
        SET_VARIABLE;

    }
}

