/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.config.Configuration;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtManager<R extends ConnectRecord<R>> {
    private static final String ENVELOPE_SCHEMA_NAME_SUFFIX = ".Envelope";
    private static final String RECORD_ENVELOPE_KEY_SCHEMA_NAME_SUFFIX = ".Key";
    private static final Logger LOGGER = LoggerFactory.getLogger(SmtManager.class);

    public SmtManager(Configuration config) {
    }

    public boolean isValidEnvelope(R record) {
        if (record.valueSchema() == null || record.valueSchema().name() == null || !record.valueSchema().name().endsWith(ENVELOPE_SCHEMA_NAME_SUFFIX)) {
            LOGGER.warn("Expected Envelope for transformation, passing it unchanged");
            return false;
        }
        return true;
    }

    public boolean isValidKey(R record) {
        if (record.keySchema() == null || record.keySchema().name() == null || !record.keySchema().name().endsWith(RECORD_ENVELOPE_KEY_SCHEMA_NAME_SUFFIX)) {
            LOGGER.warn("Expected Key Schema for transformation, passing it unchanged. Message key: \"{}\"", record.key());
            return false;
        }
        return true;
    }
}

