/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.annotation.Immutable;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class IoUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoUtil.class);

    public static byte[] readBytes(InputStream stream) throws IOException {
        if (stream == null) {
            return new byte[0];
        }
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int numRead = 0;
            while ((numRead = stream.read(buffer)) > -1) {
                output.write(buffer, 0, numRead);
            }
            output.flush();
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static byte[] readBytes(File file) throws IOException {
        if (file == null) {
            return new byte[0];
        }
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
            byte[] byArray = IoUtil.readBytes(stream);
            return byArray;
        }
    }

    public static void readLines(String resourcePath, ClassLoader classLoader, Class<?> clazz, Consumer<String> lineProcessor) throws IOException {
        try (InputStream stream = IoUtil.getResourceAsStream(resourcePath, classLoader, clazz, null, null);){
            IoUtil.readLines(stream, lineProcessor);
        }
    }

    public static void readLines(InputStream stream, Consumer<String> lineProcessor) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                lineProcessor.accept(line);
            }
        }
    }

    public static void readLines(InputStream stream, Consumer<String> lineProcessor, Charset charset) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                lineProcessor.accept(line);
            }
        }
    }

    public static void readLines(Path path, Consumer<String> lineProcessor) throws IOException {
        Files.lines(path).forEach(lineProcessor);
    }

    public static String read(Reader reader) throws IOException {
        if (reader == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try (Reader r = reader;){
            int numRead = 0;
            char[] buffer = new char[1024];
            while ((numRead = reader.read(buffer)) > -1) {
                sb.append(buffer, 0, numRead);
            }
        }
        return sb.toString();
    }

    public static String read(InputStream stream) throws IOException {
        return stream == null ? "" : IoUtil.read(new InputStreamReader(stream));
    }

    public static String read(InputStream stream, String charset) throws IOException {
        return stream == null ? "" : IoUtil.read(new InputStreamReader(stream, charset));
    }

    public static String read(File file) throws IOException {
        if (file == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try (FileReader reader = new FileReader(file);){
            int numRead = 0;
            char[] buffer = new char[1024];
            while ((numRead = reader.read(buffer)) > -1) {
                sb.append(buffer, 0, numRead);
            }
        }
        return sb.toString();
    }

    public static InputStream getResourceAsStream(String resourcePath, ClassLoader classLoader, Class<?> clazz, String resourceDesc, Consumer<String> logger) {
        InputStream result;
        if (resourcePath == null) {
            throw new IllegalArgumentException("resourcePath may not be null");
        }
        if (resourceDesc == null && logger != null) {
            resourceDesc = resourcePath;
        }
        if ((result = null) == null) {
            try {
                Path filePath = FileSystems.getDefault().getPath(resourcePath, new String[0]).toAbsolutePath();
                File f = filePath.toFile();
                if (f.exists() && f.isFile() && f.canRead()) {
                    result = new BufferedInputStream(new FileInputStream(f));
                }
                IoUtil.logMessage(result, logger, resourceDesc, "on filesystem at " + filePath);
            }
            catch (InvalidPathException filePath) {
            }
            catch (FileNotFoundException filePath) {
                // empty catch block
            }
        }
        if (result == null) {
            try {
                Path current = FileSystems.getDefault().getPath(".", new String[0]).toAbsolutePath();
                Path absolute = current.resolve(Paths.get(resourcePath, new String[0])).toAbsolutePath();
                File f = absolute.toFile();
                if (f.exists() && f.isFile() && f.canRead()) {
                    result = new BufferedInputStream(new FileInputStream(f));
                }
                IoUtil.logMessage(result, logger, resourceDesc, "on filesystem relative to '" + current + "' at '" + absolute + "'");
            }
            catch (InvalidPathException current) {
            }
            catch (FileNotFoundException current) {
                // empty catch block
            }
        }
        if (result == null && classLoader != null) {
            result = classLoader.getResourceAsStream(resourcePath);
            IoUtil.logMessage(result, logger, resourceDesc, "on classpath");
        }
        if (result == null && clazz != null) {
            result = clazz.getResourceAsStream(resourcePath);
            if (result == null) {
                result = clazz.getClassLoader().getResourceAsStream(resourcePath);
            }
            IoUtil.logMessage(result, logger, resourceDesc, "on classpath");
        }
        if (result == null) {
            try {
                URL url = new URL(resourcePath);
                result = url.openStream();
                IoUtil.logMessage(result, logger, resourceDesc, "at URL " + url.toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public static File createDirectory(Path path) {
        File dir = path.toAbsolutePath().toFile();
        if (dir.exists() && dir.canRead() && dir.canWrite()) {
            if (dir.isDirectory()) {
                return dir;
            }
            throw new IllegalStateException("Expecting '" + path + "' to be a directory but found a file");
        }
        dir.mkdirs();
        return dir;
    }

    public static File createFile(Path path) {
        File file = path.toAbsolutePath().toFile();
        if (file.exists() && file.canRead() && file.canWrite()) {
            if (file.isFile()) {
                return file;
            }
            throw new IllegalStateException("Expecting '" + path + "' to be a file but found a directory");
        }
        file.getParentFile().mkdirs();
        try {
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create the file '" + path + "': " + e.getMessage(), e);
        }
        return file;
    }

    public static File createDirectory(Path path, boolean removeExistingContent) throws IOException {
        File dir = path.toAbsolutePath().toFile();
        if (dir.exists() && dir.canRead() && dir.canWrite()) {
            if (dir.isDirectory()) {
                IoUtil.delete(path);
                return dir;
            }
            throw new IllegalStateException("Expecting '" + path + "' to be a directory but found a file");
        }
        dir.mkdirs();
        return dir;
    }

    public static void delete(String path) throws IOException {
        if (path != null) {
            IoUtil.delete(Paths.get(path, new String[0]));
        }
    }

    public static void delete(File fileOrFolder) throws IOException {
        if (fileOrFolder != null) {
            IoUtil.delete(fileOrFolder.toPath());
        }
    }

    public static void delete(File ... filesOrFolder) throws IOException {
        for (File fileOrFolder : filesOrFolder) {
            IoUtil.delete(fileOrFolder);
        }
    }

    public static void delete(Path path) throws IOException {
        if (path != null && path.toAbsolutePath().toFile().exists()) {
            LOGGER.debug("Deleting '{}'...", (Object)path);
            EnumSet<FileVisitOption> options = EnumSet.noneOf(FileVisitOption.class);
            int maxDepth = 10;
            SimpleFileVisitor<Path> removingVisitor = new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    LOGGER.error("Unable to remove '{}'", (Object)file.getFileName(), (Object)exc);
                    return FileVisitResult.CONTINUE;
                }
            };
            Files.walkFileTree(path, options, maxDepth, (FileVisitor<? super Path>)removingVisitor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getAvailablePort() {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot find available port: " + e.getMessage(), e);
        }
    }

    private static void logMessage(InputStream stream, Consumer<String> logger, String resourceDesc, String msg) {
        if (stream != null && logger != null) {
            logger.accept("Found " + resourceDesc + " " + msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadProperties(Supplier<ClassLoader> classLoader, String classpathResource) {
        try (InputStream stream = classLoader.get().getResourceAsStream(classpathResource);){
            Properties props = new Properties();
            props.load(stream);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to find or read the '" + classpathResource + "' file using the " + classLoader + " class loader", e);
        }
    }

    public static Properties loadProperties(ClassLoader classLoader, String classpathResource) {
        return IoUtil.loadProperties(() -> classLoader, classpathResource);
    }

    public static Properties loadProperties(Class<?> clazz, String classpathResource) {
        return IoUtil.loadProperties(clazz::getClassLoader, classpathResource);
    }

    private IoUtil() {
    }
}

