/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnwrapFromEnvelope<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final String ENVELOPE_SCHEMA_NAME_SUFFIX = ".Envelope";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Field DROP_TOMBSTONES = Field.create("drop.tombstones").withDisplayName("Drop tombstones").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(true).withDescription("Debezium by default generates a tombstone record to enable Kafka compaction after a delete record was generated. This record is usually filtered out to avoid duplicates as a delete record is converted to a tombstone record, too");
    private static final Field DROP_DELETES = Field.create("drop.deletes").withDisplayName("Drop outgoing tombstones").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(true).withDescription("Drop delete records converted to tombstones records if a processing connector cannot process them or a compaction is undesirable.");
    private boolean dropTombstones;
    private boolean dropDeletes;
    private final ExtractField<R> delegate = new ExtractField.Value();

    public void configure(Map<String, ?> configs) {
        Configuration config = Configuration.from(configs);
        Field.Set configFields = Field.setOf(DROP_TOMBSTONES, DROP_DELETES);
        if (!config.validateAndRecord(configFields, arg_0 -> ((Logger)this.logger).error(arg_0))) {
            throw new ConnectException("Unable to validate config.");
        }
        this.dropTombstones = config.getBoolean(DROP_TOMBSTONES);
        this.dropDeletes = config.getBoolean(DROP_DELETES);
        HashMap<String, String> delegateConfig = new HashMap<String, String>();
        delegateConfig.put("field", "after");
        this.delegate.configure(delegateConfig);
    }

    public R apply(R record) {
        if (record.value() == null) {
            if (this.dropTombstones) {
                this.logger.trace("Tombstone {} arrived and requested to be dropped", record.key());
                return null;
            }
            return record;
        }
        if (record.valueSchema() == null || record.valueSchema().name() == null || !record.valueSchema().name().endsWith(ENVELOPE_SCHEMA_NAME_SUFFIX)) {
            this.logger.warn("Expected Envelope for transformation, passing it unchanged");
            return record;
        }
        ConnectRecord newRecord = this.delegate.apply(record);
        if (newRecord.value() == null && this.dropDeletes) {
            this.logger.trace("Delete message {} requested to be dropped", record.key());
            return null;
        }
        return (R)newRecord;
    }

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group(config, null, DROP_TOMBSTONES, DROP_DELETES);
        return config;
    }

    public void close() {
        this.delegate.close();
    }
}

