/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.TableSchema;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.util.Clock;
import java.util.Objects;
import org.apache.kafka.connect.data.Struct;

public abstract class RelationalChangeRecordEmitter
implements ChangeRecordEmitter {
    private final OffsetContext offsetContext;
    private final Clock clock;

    public RelationalChangeRecordEmitter(OffsetContext offsetContext, Clock clock) {
        this.offsetContext = offsetContext;
        this.clock = clock;
    }

    @Override
    public void emitChangeRecords(DataCollectionSchema schema, ChangeRecordEmitter.Receiver receiver) throws InterruptedException {
        TableSchema tableSchema = (TableSchema)schema;
        Envelope.Operation operation = this.getOperation();
        switch (operation) {
            case CREATE: {
                this.emitCreateRecord(receiver, tableSchema, operation);
                break;
            }
            case UPDATE: {
                this.emitUpdateRecord(receiver, tableSchema, operation);
                break;
            }
            case DELETE: {
                this.emitDeleteRecord(receiver, tableSchema, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation: " + (Object)((Object)operation));
            }
        }
    }

    private void emitCreateRecord(ChangeRecordEmitter.Receiver receiver, TableSchema tableSchema, Envelope.Operation operation) throws InterruptedException {
        Object[] newColumnValues = this.getNewColumnValues();
        Object newKey = tableSchema.keyFromColumnData(newColumnValues);
        Struct newValue = tableSchema.valueFromColumnData(newColumnValues);
        Struct envelope = tableSchema.getEnvelopeSchema().create(newValue, this.offsetContext.getSourceInfo(), this.clock.currentTimeInMillis());
        receiver.changeRecord(operation, newKey, envelope, this.offsetContext);
    }

    private void emitUpdateRecord(ChangeRecordEmitter.Receiver receiver, TableSchema tableSchema, Envelope.Operation operation) throws InterruptedException {
        Object[] oldColumnValues = this.getOldColumnValues();
        Object[] newColumnValues = this.getNewColumnValues();
        Object oldKey = tableSchema.keyFromColumnData(oldColumnValues);
        Object newKey = tableSchema.keyFromColumnData(newColumnValues);
        Struct newValue = tableSchema.valueFromColumnData(newColumnValues);
        Struct oldValue = tableSchema.valueFromColumnData(oldColumnValues);
        if (Objects.equals(oldKey, newKey)) {
            Struct envelope = tableSchema.getEnvelopeSchema().update(oldValue, newValue, this.offsetContext.getSourceInfo(), this.clock.currentTimeInMillis());
            receiver.changeRecord(operation, newKey, envelope, this.offsetContext);
        } else {
            Struct envelope = tableSchema.getEnvelopeSchema().delete(oldValue, this.offsetContext.getSourceInfo(), this.clock.currentTimeInMillis());
            receiver.changeRecord(Envelope.Operation.DELETE, oldKey, envelope, this.offsetContext);
            envelope = tableSchema.getEnvelopeSchema().create(newValue, this.offsetContext.getSourceInfo(), this.clock.currentTimeInMillis());
            receiver.changeRecord(operation, oldKey, envelope, this.offsetContext);
        }
    }

    private void emitDeleteRecord(ChangeRecordEmitter.Receiver receiver, TableSchema tableSchema, Envelope.Operation operation) throws InterruptedException {
        Object[] oldColumnValues = this.getOldColumnValues();
        Object oldKey = tableSchema.keyFromColumnData(oldColumnValues);
        Struct oldValue = tableSchema.valueFromColumnData(oldColumnValues);
        Struct envelope = tableSchema.getEnvelopeSchema().delete(oldValue, this.offsetContext.getSourceInfo(), this.clock.currentTimeInMillis());
        receiver.changeRecord(operation, oldKey, envelope, this.offsetContext);
    }

    protected abstract Envelope.Operation getOperation();

    protected abstract Object[] getOldColumnValues();

    protected abstract Object[] getNewColumnValues();
}

