/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data;

import io.debezium.data.SpecialValueDecimal;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class VariableScaleDecimal {
    public static final String LOGICAL_NAME = "io.debezium.data.VariableScaleDecimal";
    public static final String VALUE_FIELD = "value";
    public static final String SCALE_FIELD = "scale";
    public static final Struct ZERO = VariableScaleDecimal.fromLogical(VariableScaleDecimal.schema(), SpecialValueDecimal.ZERO);

    public static SchemaBuilder builder() {
        return SchemaBuilder.struct().name(LOGICAL_NAME).version(Integer.valueOf(1)).doc("Variable scaled decimal").field(SCALE_FIELD, Schema.INT32_SCHEMA).field(VALUE_FIELD, Schema.BYTES_SCHEMA);
    }

    public static Schema schema() {
        return VariableScaleDecimal.builder().build();
    }

    public static Schema optionalSchema() {
        return VariableScaleDecimal.builder().optional().build();
    }

    public static Struct fromLogical(Schema schema, SpecialValueDecimal value) {
        Struct result = new Struct(schema);
        BigDecimal decimalValue = value.getDecimalValue().orElse(null);
        assert (decimalValue != null) : "Unable to encode special value";
        result.put(VALUE_FIELD, (Object)decimalValue.unscaledValue().toByteArray());
        result.put(SCALE_FIELD, (Object)decimalValue.scale());
        return result;
    }

    public static SpecialValueDecimal toLogical(Struct value) {
        return new SpecialValueDecimal(new BigDecimal(new BigInteger(value.getBytes(VALUE_FIELD)), value.getInt32(SCALE_FIELD)));
    }
}

