/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.base;

import io.debezium.config.ConfigurationDefaults;
import io.debezium.time.Temporals;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import io.debezium.util.Metronome;
import io.debezium.util.Threads;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Supplier;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeEventQueue<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeEventQueue.class);
    private final Duration pollInterval;
    private final int maxBatchSize;
    private final BlockingQueue<T> queue;
    private final Metronome metronome;
    private final Supplier<LoggingContext.PreviousContext> loggingContextSupplier;
    private volatile Throwable producerFailure;

    private ChangeEventQueue(Duration pollInterval, int maxQueueSize, int maxBatchSize, Supplier<LoggingContext.PreviousContext> loggingContextSupplier) {
        this.pollInterval = pollInterval;
        this.maxBatchSize = maxBatchSize;
        this.queue = new LinkedBlockingDeque<T>(maxQueueSize);
        this.metronome = Metronome.sleeper(pollInterval, Clock.SYSTEM);
        this.loggingContextSupplier = loggingContextSupplier;
    }

    public void enqueue(T record) throws InterruptedException {
        if (record == null) {
            return;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Enqueuing source record '{}'", record);
        }
        this.queue.put(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> poll() throws InterruptedException {
        LoggingContext.PreviousContext previousContext = this.loggingContextSupplier.get();
        try {
            LOGGER.debug("polling records...");
            ArrayList records = new ArrayList();
            Threads.Timer timeout = Threads.timer(Clock.SYSTEM, Temporals.max(this.pollInterval, ConfigurationDefaults.RETURN_CONTROL_INTERVAL));
            while (!timeout.expired() && this.queue.drainTo(records, this.maxBatchSize) == 0) {
                this.throwProducerFailureIfPresent();
                LOGGER.debug("no records available yet, sleeping a bit...");
                this.metronome.pause();
                LOGGER.debug("checking for more records...");
            }
            ArrayList arrayList = records;
            return arrayList;
        }
        finally {
            previousContext.restore();
        }
    }

    public void producerFailure(Throwable producerFailure) {
        this.producerFailure = producerFailure;
    }

    private void throwProducerFailureIfPresent() {
        if (this.producerFailure != null) {
            throw new ConnectException("An exception ocurred in the change event producer. This connector will be stopped.", this.producerFailure);
        }
    }

    public static class Builder<T> {
        private Duration pollInterval;
        private int maxQueueSize;
        private int maxBatchSize;
        private Supplier<LoggingContext.PreviousContext> loggingContextSupplier;

        public Builder<T> pollInterval(Duration pollInterval) {
            this.pollInterval = pollInterval;
            return this;
        }

        public Builder<T> maxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public Builder<T> maxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public Builder<T> loggingContextSupplier(Supplier<LoggingContext.PreviousContext> loggingContextSupplier) {
            this.loggingContextSupplier = loggingContextSupplier;
            return this;
        }

        public ChangeEventQueue<T> build() {
            return new ChangeEventQueue(this.pollInterval, this.maxQueueSize, this.maxBatchSize, this.loggingContextSupplier);
        }
    }
}

