/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.util.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

@FunctionalInterface
public interface Metronome {
    public void pause() throws InterruptedException;

    public static Metronome sleeper(long period, TimeUnit unit, final Clock timeSystem) {
        final long periodInMillis = unit.toMillis(period);
        return new Metronome(){
            private long next;
            {
                this.next = timeSystem.currentTimeInMillis() + periodInMillis;
            }

            @Override
            public void pause() throws InterruptedException {
                while (this.next > timeSystem.currentTimeInMillis()) {
                    Thread.sleep(this.next - timeSystem.currentTimeInMillis());
                }
                this.next += periodInMillis;
            }

            public String toString() {
                return "Metronome (sleep for " + periodInMillis + " ms)";
            }
        };
    }

    public static Metronome parker(long period, TimeUnit unit, final Clock timeSystem) {
        final long periodInNanos = unit.toNanos(period);
        return new Metronome(){
            private long next;
            {
                this.next = timeSystem.currentTimeInNanos() + periodInNanos;
            }

            @Override
            public void pause() throws InterruptedException {
                while (this.next > timeSystem.currentTimeInNanos()) {
                    LockSupport.parkNanos(this.next - timeSystem.currentTimeInNanos());
                    if (!Thread.currentThread().isInterrupted()) continue;
                    throw new InterruptedException();
                }
                this.next += periodInNanos;
            }

            public String toString() {
                return "Metronome (park for " + TimeUnit.NANOSECONDS.toMillis(periodInNanos) + " ms)";
            }
        };
    }
}

