/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;
import io.debezium.annotation.ThreadSafe;
import io.debezium.data.SchemaUtil;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnId;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.relational.mapping.ColumnMapper;
import io.debezium.relational.mapping.ColumnMappers;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Immutable
public class TableSchemaBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableSchemaBuilder.class);
    private final Function<String, String> schemaNameValidator;
    private final ValueConverterProvider valueConverterProvider;

    public TableSchemaBuilder(ValueConverterProvider valueConverterProvider, Function<String, String> schemaNameValidator) {
        this.schemaNameValidator = schemaNameValidator;
        this.valueConverterProvider = valueConverterProvider;
    }

    public TableSchema create(ResultSet resultSet, String name) throws SQLException {
        ArrayList<Column> columns = new ArrayList<Column>();
        JdbcConnection.columnsFor(resultSet, columns::add);
        String schemaName = this.schemaNameValidator.apply(name);
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().name(schemaName);
        columns.forEach(column -> this.addField(schemaBuilder, (Column)column, null));
        Schema valueSchema = schemaBuilder.build();
        TableId id = new TableId(null, null, name);
        Function<Object[], Struct> valueGenerator = this.createValueGenerator(valueSchema, id, columns, null, null);
        return new TableSchema(null, null, valueSchema, valueGenerator);
    }

    public TableSchema create(String schemaPrefix, Table table) {
        return this.create(schemaPrefix, table, null, null);
    }

    public TableSchema create(String schemaPrefix, Table table, Predicate<ColumnId> filter, ColumnMappers mappers) {
        Schema keySchema;
        if (schemaPrefix == null) {
            schemaPrefix = "";
        }
        TableId tableId = table.id();
        String tableIdStr = tableId.toString();
        String schemaNamePrefix = schemaPrefix + tableIdStr;
        LOGGER.debug("Mapping table '{}' to schemas under '{}'", (Object)tableId, (Object)schemaNamePrefix);
        SchemaBuilder valSchemaBuilder = SchemaBuilder.struct().name(this.schemaNameValidator.apply(schemaNamePrefix + ".Value"));
        SchemaBuilder keySchemaBuilder = SchemaBuilder.struct().name(this.schemaNameValidator.apply(schemaNamePrefix + ".Key"));
        AtomicBoolean hasPrimaryKey = new AtomicBoolean(false);
        table.columns().forEach(column -> {
            if (table.isPrimaryKeyColumn(column.name())) {
                this.addField(keySchemaBuilder, (Column)column, null);
                hasPrimaryKey.set(true);
            }
            if (filter == null || filter.test(new ColumnId(tableId, column.name()))) {
                ColumnMapper mapper = mappers == null ? null : mappers.mapperFor(tableId, (Column)column);
                this.addField(valSchemaBuilder, (Column)column, mapper);
            }
        });
        Schema valSchema = valSchemaBuilder.optional().build();
        Schema schema = keySchema = hasPrimaryKey.get() ? keySchemaBuilder.build() : null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Mapped primary key for table '{}' to schema: {}", (Object)tableId, (Object)SchemaUtil.asDetailedString(keySchema));
            LOGGER.debug("Mapped columns for table '{}' to schema: {}", (Object)tableId, (Object)SchemaUtil.asDetailedString(valSchema));
        }
        Function<Object[], Object> keyGenerator = this.createKeyGenerator(keySchema, tableId, table.primaryKeyColumns());
        Function<Object[], Struct> valueGenerator = this.createValueGenerator(valSchema, tableId, table.columns(), filter, mappers);
        return new TableSchema(keySchema, keyGenerator, valSchema, valueGenerator);
    }

    protected Function<Object[], Object> createKeyGenerator(Schema schema, TableId columnSetName, List<Column> columns) {
        if (schema != null) {
            int[] recordIndexes = this.indexesForColumns(columns);
            Field[] fields = this.fieldsForColumns(schema, columns);
            int numFields = recordIndexes.length;
            ValueConverter[] converters = this.convertersForColumns(schema, columnSetName, columns, null, null);
            return row -> {
                Struct result = new Struct(schema);
                for (int i = 0; i != numFields; ++i) {
                    Object value = row[recordIndexes[i]];
                    ValueConverter converter = converters[i];
                    if (converter == null) continue;
                    value = value == null ? value : converter.convert(value);
                    try {
                        result.put(fields[i], value);
                        continue;
                    }
                    catch (DataException e) {
                        Column col = (Column)columns.get(i);
                        LOGGER.error("Failed to properly convert key value for '{}.{}' of type {} for row {}:", new Object[]{columnSetName, col.name(), col.typeName(), row, e});
                    }
                }
                return result;
            };
        }
        return null;
    }

    protected Function<Object[], Struct> createValueGenerator(Schema schema, TableId tableId, List<Column> columns, Predicate<ColumnId> filter, ColumnMappers mappers) {
        if (schema != null) {
            int[] recordIndexes = this.indexesForColumns(columns);
            Field[] fields = this.fieldsForColumns(schema, columns);
            int numFields = recordIndexes.length;
            ValueConverter[] converters = this.convertersForColumns(schema, tableId, columns, filter, mappers);
            AtomicBoolean traceMessage = new AtomicBoolean(true);
            return row -> {
                Struct result = new Struct(schema);
                for (int i = 0; i != numFields; ++i) {
                    Object value = row[recordIndexes[i]];
                    ValueConverter converter = converters[i];
                    if (converter != null) {
                        try {
                            value = converter.convert(value);
                            result.put(fields[i], value);
                        }
                        catch (IllegalArgumentException | DataException e) {
                            Column col = (Column)columns.get(i);
                            LOGGER.error("Failed to properly convert data value for '{}.{}' of type {} for row {}:", new Object[]{tableId, col.name(), col.typeName(), row, e});
                        }
                        continue;
                    }
                    if (!traceMessage.getAndSet(false)) continue;
                    Column col = (Column)columns.get(i);
                    LOGGER.trace("Excluding '{}.{}' of type {}", new Object[]{tableId, col.name(), col.typeName()});
                }
                return result;
            };
        }
        return null;
    }

    protected int[] indexesForColumns(List<Column> columns) {
        int[] recordIndexes = new int[columns.size()];
        AtomicInteger i = new AtomicInteger(0);
        columns.forEach(column -> {
            recordIndexes[i.getAndIncrement()] = column.position() - 1;
        });
        return recordIndexes;
    }

    protected Field[] fieldsForColumns(Schema schema, List<Column> columns) {
        Field[] fields = new Field[columns.size()];
        AtomicInteger i = new AtomicInteger(0);
        columns.forEach(column -> {
            Field field;
            fields[i.getAndIncrement()] = field = schema.field(column.name());
        });
        return fields;
    }

    protected ValueConverter[] convertersForColumns(Schema schema, TableId tableId, List<Column> columns, Predicate<ColumnId> filter, ColumnMappers mappers) {
        ValueConverter[] converters = new ValueConverter[columns.size()];
        AtomicInteger i = new AtomicInteger(0);
        columns.forEach(column -> {
            Field field = schema.field(column.name());
            ValueConverter converter = null;
            if (filter == null || filter.test(new ColumnId(tableId, column.name()))) {
                ValueConverter mappingConverter;
                ValueConverter valueConverter = this.createValueConverterFor((Column)column, field);
                assert (valueConverter != null);
                if (mappers != null && (mappingConverter = mappers.mappingConverterFor(tableId, (Column)column)) != null) {
                    converter = value -> {
                        if (value != null) {
                            value = valueConverter.convert(value);
                        }
                        return mappingConverter.convert(value);
                    };
                }
                if (converter == null) {
                    converter = valueConverter;
                }
                assert (converter != null);
            }
            converters[i.getAndIncrement()] = converter;
        });
        return converters;
    }

    protected void addField(SchemaBuilder builder, Column column, ColumnMapper mapper) {
        SchemaBuilder fieldBuilder = this.valueConverterProvider.schemaBuilder(column);
        if (fieldBuilder != null) {
            if (mapper != null) {
                mapper.alterFieldSchema(column, fieldBuilder);
            }
            if (column.isOptional()) {
                fieldBuilder.optional();
            }
            builder.field(column.name(), fieldBuilder.build());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("- field '{}' ({}{}) from column {}", new Object[]{column.name(), builder.isOptional() ? "OPTIONAL " : "", fieldBuilder.type(), column});
            }
        } else {
            LOGGER.warn("Unexpected JDBC type '{}' for column '{}' that will be ignored", (Object)column.jdbcType(), (Object)column.name());
        }
    }

    protected ValueConverter createValueConverterFor(Column column, Field fieldDefn) {
        return this.valueConverterProvider.converter(column, fieldDefn);
    }
}

