/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.mapping;

import io.debezium.annotation.Immutable;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.mapping.ColumnMapper;
import org.apache.kafka.connect.data.SchemaBuilder;

public class MaskStrings
implements ColumnMapper {
    private final MaskingValueConverter converter;

    public MaskStrings(String maskValue) {
        if (maskValue == null) {
            throw new IllegalArgumentException("Mask value may not be null");
        }
        this.converter = new MaskingValueConverter(maskValue);
    }

    @Override
    public ValueConverter create(Column column) {
        switch (column.jdbcType()) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 70: 
            case 2005: 
            case 2011: {
                return this.converter;
            }
        }
        return ValueConverter.passthrough();
    }

    @Override
    public void alterFieldSchema(Column column, SchemaBuilder schemaBuilder) {
        schemaBuilder.parameter("masked", "true");
    }

    @Immutable
    protected static final class MaskingValueConverter
    implements ValueConverter {
        protected final String maskValue;

        public MaskingValueConverter(String maskValue) {
            this.maskValue = maskValue;
            assert (this.maskValue != null);
        }

        @Override
        public Object convert(Object value) {
            return this.maskValue;
        }
    }
}

