/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.time;

import io.debezium.time.Conversions;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class ZonedTime {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_TIME;
    public static final String SCHEMA_NAME = "io.debezium.time.ZonedTime";

    public static SchemaBuilder builder() {
        return SchemaBuilder.string().name(SCHEMA_NAME).version(Integer.valueOf(1));
    }

    public static Schema schema() {
        return ZonedTime.builder().build();
    }

    public static String toIsoString(Object value, ZoneId defaultZone) {
        if (value instanceof OffsetTime) {
            return ZonedTime.toIsoString((OffsetTime)value);
        }
        if (value instanceof OffsetDateTime) {
            return ZonedTime.toIsoString((OffsetDateTime)value);
        }
        if (value instanceof Date) {
            return ZonedTime.toIsoString((Date)value, defaultZone);
        }
        throw new IllegalArgumentException("Unable to convert to OffsetTime from unexpected value '" + value + "' of type " + value.getClass().getName());
    }

    public static String toIsoString(OffsetDateTime timestamp) {
        return timestamp.toOffsetTime().format(FORMATTER);
    }

    public static String toIsoString(OffsetTime timestamp) {
        return timestamp.format(FORMATTER);
    }

    public static String toIsoString(Date timestamp, ZoneId zoneId) {
        if (timestamp instanceof Timestamp) {
            return ZonedTime.toIsoString((Timestamp)timestamp, zoneId);
        }
        if (timestamp instanceof java.sql.Date) {
            return ZonedTime.toIsoString((java.sql.Date)timestamp, zoneId);
        }
        if (timestamp instanceof Time) {
            return ZonedTime.toIsoString((Time)timestamp, zoneId);
        }
        return timestamp.toInstant().atZone(zoneId).format(FORMATTER);
    }

    public static String toIsoString(Timestamp timestamp, ZoneId zoneId) {
        ZonedDateTime zdt = timestamp.toInstant().atZone(zoneId);
        return zdt.format(FORMATTER);
    }

    public static String toIsoString(java.sql.Date date, ZoneId zoneId) {
        LocalDate localDate = date.toLocalDate();
        ZonedDateTime zdt = ZonedDateTime.of(localDate, LocalTime.MIDNIGHT, zoneId);
        return zdt.format(FORMATTER);
    }

    public static String toIsoString(Time time, ZoneId zoneId) {
        LocalTime localTime = time.toLocalTime();
        ZonedDateTime zdt = ZonedDateTime.of(Conversions.EPOCH, localTime, zoneId);
        return zdt.format(FORMATTER);
    }

    private ZonedTime() {
    }
}

