/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver.rest;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.sqlserver.Module;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.rest.ConnectionValidationResource;
import io.debezium.rest.FilterValidationResource;
import io.debezium.rest.SchemaResource;
import io.debezium.rest.model.DataCollection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.kafka.connect.connector.Connector;

@Path(value="/debezium/sqlserver")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DebeziumSqlServerConnectorResource
implements SchemaResource,
ConnectionValidationResource,
FilterValidationResource {
    public static final String BASE_PATH = "/debezium/sqlserver";
    public static final String VERSION_ENDPOINT = "/version";

    @GET
    @Path(value="/version")
    public String getConnectorVersion() {
        return Module.version();
    }

    public Connector getConnector() {
        return new SqlServerConnector();
    }

    public List<DataCollection> getMatchingCollections(Configuration configuration) {
        List<DataCollection> list;
        SqlServerConnectorConfig sqlServerConfig = new SqlServerConnectorConfig(configuration);
        List<String> databaseNames = sqlServerConfig.getDatabaseNames();
        SqlServerConnection connection = new SqlServerConnection(sqlServerConfig, null, Collections.emptySet(), sqlServerConfig.useSingleDatabase());
        try {
            HashSet tables = new HashSet();
            databaseNames.forEach(databaseName -> {
                try {
                    tables.addAll(connection.readTableNames((String)databaseName, null, null, new String[]{"TABLE"}));
                }
                catch (SQLException e) {
                    throw new DebeziumException((Throwable)e);
                }
            });
            list = tables.stream().filter(tableId -> sqlServerConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId)).map(tableId -> new DataCollection(tableId.catalog(), tableId.schema(), tableId.table())).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new RuntimeException("Could not retrieve real database name", e);
            }
        }
        connection.close();
        return list;
    }

    public String getSchemaFilePath() {
        return "/META-INF/resources/sqlserver.json";
    }
}

