/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.sqlserver.Lsn;
import io.debezium.connector.sqlserver.SourceInfo;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.TxLogPosition;
import io.debezium.pipeline.CommonOffsetContext;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;

public class SqlServerOffsetContext
extends CommonOffsetContext<SourceInfo> {
    private static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    private final Schema sourceInfoSchema;
    private boolean snapshotCompleted;
    private final TransactionContext transactionContext;
    private final IncrementalSnapshotContext<TableId> incrementalSnapshotContext;
    private long eventSerialNo;

    public SqlServerOffsetContext(SqlServerConnectorConfig connectorConfig, TxLogPosition position, boolean snapshot, boolean snapshotCompleted, long eventSerialNo, TransactionContext transactionContext, IncrementalSnapshotContext<TableId> incrementalSnapshotContext) {
        super((BaseSourceInfo)new SourceInfo(connectorConfig));
        ((SourceInfo)this.sourceInfo).setCommitLsn(position.getCommitLsn());
        ((SourceInfo)this.sourceInfo).setChangeLsn(position.getInTxLsn());
        this.sourceInfoSchema = ((SourceInfo)this.sourceInfo).schema();
        this.snapshotCompleted = snapshotCompleted;
        if (this.snapshotCompleted) {
            this.postSnapshotCompletion();
        } else {
            ((SourceInfo)this.sourceInfo).setSnapshot(snapshot ? SnapshotRecord.TRUE : SnapshotRecord.FALSE);
        }
        this.eventSerialNo = eventSerialNo;
        this.transactionContext = transactionContext;
        this.incrementalSnapshotContext = incrementalSnapshotContext;
    }

    public SqlServerOffsetContext(SqlServerConnectorConfig connectorConfig, TxLogPosition position, boolean snapshot, boolean snapshotCompleted) {
        this(connectorConfig, position, snapshot, snapshotCompleted, 1L, new TransactionContext(), (IncrementalSnapshotContext<TableId>)new SignalBasedIncrementalSnapshotContext());
    }

    public Map<String, ?> getOffset() {
        if (((SourceInfo)this.sourceInfo).isSnapshot()) {
            return Collect.hashMapOf((Object)"snapshot", (Object)true, (Object)SNAPSHOT_COMPLETED_KEY, (Object)this.snapshotCompleted, (Object)"commit_lsn", (Object)((SourceInfo)this.sourceInfo).getCommitLsn().toString());
        }
        return this.incrementalSnapshotContext.store(this.transactionContext.store(Collect.hashMapOf((Object)"commit_lsn", (Object)((SourceInfo)this.sourceInfo).getCommitLsn().toString(), (Object)"change_lsn", (Object)(((SourceInfo)this.sourceInfo).getChangeLsn() == null ? null : ((SourceInfo)this.sourceInfo).getChangeLsn().toString()), (Object)"event_serial_no", (Object)this.eventSerialNo)));
    }

    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    public TxLogPosition getChangePosition() {
        return TxLogPosition.valueOf(((SourceInfo)this.sourceInfo).getCommitLsn(), ((SourceInfo)this.sourceInfo).getChangeLsn());
    }

    public long getEventSerialNo() {
        return this.eventSerialNo;
    }

    public void setChangePosition(TxLogPosition position, int eventCount) {
        this.eventSerialNo = this.getChangePosition().equals(position) ? (this.eventSerialNo += (long)eventCount) : (long)eventCount;
        ((SourceInfo)this.sourceInfo).setCommitLsn(position.getCommitLsn());
        ((SourceInfo)this.sourceInfo).setChangeLsn(position.getInTxLsn());
        ((SourceInfo)this.sourceInfo).setEventSerialNo(this.eventSerialNo);
    }

    public boolean isSnapshotRunning() {
        return ((SourceInfo)this.sourceInfo).isSnapshot() && !this.snapshotCompleted;
    }

    public boolean isSnapshotCompleted() {
        return this.snapshotCompleted;
    }

    public void preSnapshotStart() {
        ((SourceInfo)this.sourceInfo).setSnapshot(SnapshotRecord.TRUE);
        this.snapshotCompleted = false;
    }

    public void preSnapshotCompletion() {
        this.snapshotCompleted = true;
    }

    public String toString() {
        return "SqlServerOffsetContext [sourceInfoSchema=" + this.sourceInfoSchema + ", sourceInfo=" + this.sourceInfo + ", snapshotCompleted=" + this.snapshotCompleted + ", eventSerialNo=" + this.eventSerialNo + "]";
    }

    public void event(DataCollectionId tableId, Instant timestamp) {
        ((SourceInfo)this.sourceInfo).setSourceTime(timestamp);
        ((SourceInfo)this.sourceInfo).setTableId((TableId)tableId);
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public IncrementalSnapshotContext<?> getIncrementalSnapshotContext() {
        return this.incrementalSnapshotContext;
    }

    public static class Loader
    implements OffsetContext.Loader<SqlServerOffsetContext> {
        private final SqlServerConnectorConfig connectorConfig;

        public Loader(SqlServerConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public SqlServerOffsetContext load(Map<String, ?> offset) {
            Lsn changeLsn = Lsn.valueOf((String)offset.get("change_lsn"));
            Lsn commitLsn = Lsn.valueOf((String)offset.get("commit_lsn"));
            boolean snapshot = Boolean.TRUE.equals(offset.get("snapshot"));
            boolean snapshotCompleted = Boolean.TRUE.equals(offset.get(SqlServerOffsetContext.SNAPSHOT_COMPLETED_KEY));
            Long eventSerialNo = (Long)offset.get("event_serial_no");
            if (eventSerialNo == null) {
                eventSerialNo = 0L;
            }
            return new SqlServerOffsetContext(this.connectorConfig, TxLogPosition.valueOf(commitLsn, changeLsn), snapshot, snapshotCompleted, eventSerialNo, TransactionContext.load(offset), (IncrementalSnapshotContext<TableId>)SignalBasedIncrementalSnapshotContext.load(offset));
        }
    }
}

