/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.sqlserver.SqlServerValueConverters;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.util.HexConverter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import microsoft.sql.DateTimeOffset;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class SqlServerDefaultValueConverter {
    private static Logger LOGGER = LoggerFactory.getLogger(SqlServerDefaultValueConverter.class);
    private final ConnectionProvider connectionProvider;
    private final SqlServerValueConverters valueConverters;
    private final Map<String, DefaultValueMapper> defaultValueMappers;

    SqlServerDefaultValueConverter(ConnectionProvider connectionProvider, SqlServerValueConverters valueConverters) {
        this.connectionProvider = connectionProvider;
        this.valueConverters = valueConverters;
        this.defaultValueMappers = Collections.unmodifiableMap(this.createDefaultValueMappers());
    }

    Optional<Object> parseDefaultValue(Column column, String defaultValue) {
        String dataType = column.typeName();
        DefaultValueMapper mapper = this.defaultValueMappers.get(dataType);
        if (mapper == null) {
            LOGGER.warn("Mapper for type '{}' not found.", (Object)dataType);
            return Optional.empty();
        }
        try {
            Object rawDefaultValue = mapper.parse(defaultValue);
            Object convertedDefaultValue = this.convertDefaultValue(rawDefaultValue, column);
            return Optional.ofNullable(convertedDefaultValue);
        }
        catch (Exception e) {
            LOGGER.warn("Cannot parse column default value '{}' to type '{}'. Expression evaluation is not supported.", (Object)defaultValue, (Object)dataType);
            LOGGER.debug("Parsing failed due to error", (Throwable)e);
            return Optional.empty();
        }
    }

    private Object convertDefaultValue(Object defaultValue, Column column) {
        if (this.valueConverters != null && defaultValue != null) {
            SchemaBuilder schemaBuilder = this.valueConverters.schemaBuilder(column);
            if (schemaBuilder == null) {
                return defaultValue;
            }
            Schema schema = schemaBuilder.build();
            Field field = new Field(column.name(), -1, schema);
            ValueConverter valueConverter = this.valueConverters.converter(column, field);
            Object result = valueConverter.convert(defaultValue);
            if (result instanceof BigDecimal && column.scale().isPresent() && (Integer)column.scale().get() > ((BigDecimal)result).scale()) {
                result = ((BigDecimal)result).setScale((int)((Integer)column.scale().get()), RoundingMode.HALF_EVEN);
            }
            return result;
        }
        return defaultValue;
    }

    private Map<String, DefaultValueMapper> createDefaultValueMappers() {
        HashMap<String, DefaultValueMapper> result = new HashMap<String, DefaultValueMapper>();
        result.put("bigint", v -> SqlServerDefaultValueConverter.nullableDefaultValueMapper(v, value -> Long.parseLong(value.charAt(value.length() - 1) == '.' ? value.substring(0, value.length() - 1) : value)));
        result.put("int", v -> SqlServerDefaultValueConverter.nullableDefaultValueMapper(v, Integer::parseInt));
        result.put("smallint", v -> SqlServerDefaultValueConverter.nullableDefaultValueMapper(v, Short::parseShort));
        result.put("tinyint", v -> SqlServerDefaultValueConverter.nullableDefaultValueMapper(v, Short::parseShort));
        result.put("bit", v -> v.equals("((1))"));
        result.put("decimal", v -> new BigDecimal(v.substring(2, v.length() - 2)));
        result.put("numeric", v -> new BigDecimal(v.substring(2, v.length() - 2)));
        result.put("money", v -> new BigDecimal(v.substring(2, v.length() - 2)));
        result.put("smallmoney", v -> new BigDecimal(v.substring(2, v.length() - 2)));
        result.put("float", v -> SqlServerDefaultValueConverter.nullableDefaultValueMapper(v, Double::parseDouble));
        result.put("real", v -> SqlServerDefaultValueConverter.nullableDefaultValueMapper(v, Float::parseFloat));
        result.put("date", v -> {
            String rawValue = v.substring(2, v.length() - 2);
            return JdbcConnection.querySingleValue((Connection)this.connectionProvider.get(), (String)"SELECT PARSE(? AS date)", st -> st.setString(1, rawValue), rs -> rs.getDate(1));
        });
        result.put("datetime", v -> {
            String rawValue = v.substring(2, v.length() - 2);
            return JdbcConnection.querySingleValue((Connection)this.connectionProvider.get(), (String)"SELECT PARSE(? AS datetime)", st -> st.setString(1, rawValue), rs -> rs.getTimestamp(1));
        });
        result.put("datetime2", v -> {
            String rawValue = v.substring(2, v.length() - 2);
            return JdbcConnection.querySingleValue((Connection)this.connectionProvider.get(), (String)"SELECT PARSE(? AS datetime2)", st -> st.setString(1, rawValue), rs -> rs.getTimestamp(1));
        });
        result.put("datetimeoffset", v -> {
            String rawValue = v.substring(2, v.length() - 2);
            return JdbcConnection.querySingleValue((Connection)this.connectionProvider.get(), (String)"SELECT PARSE(? AS datetimeoffset)", st -> st.setString(1, rawValue), rs -> (DateTimeOffset)rs.getObject(1));
        });
        result.put("smalldatetime", v -> {
            String rawValue = v.substring(2, v.length() - 2);
            return JdbcConnection.querySingleValue((Connection)this.connectionProvider.get(), (String)"SELECT PARSE(? AS smalldatetime)", st -> st.setString(1, rawValue), rs -> rs.getTimestamp(1));
        });
        result.put("time", v -> {
            String rawValue = v.substring(2, v.length() - 2);
            return JdbcConnection.querySingleValue((Connection)this.connectionProvider.get(), (String)"SELECT PARSE(? AS time)", st -> st.setString(1, rawValue), rs -> rs.getTime(1));
        });
        result.put("char", v -> v.substring(2, v.length() - 2));
        result.put("text", v -> v.substring(2, v.length() - 2));
        result.put("varchar", v -> v.substring(2, v.length() - 2));
        result.put("nchar", v -> v.substring(2, v.length() - 2));
        result.put("ntext", v -> v.substring(2, v.length() - 2));
        result.put("nvarchar", v -> v.substring(2, v.length() - 2));
        result.put("binary", v -> HexConverter.convertFromHex((String)v.substring(3, v.length() - 1)));
        result.put("image", v -> HexConverter.convertFromHex((String)v.substring(3, v.length() - 1)));
        result.put("varbinary", v -> HexConverter.convertFromHex((String)v.substring(3, v.length() - 1)));
        return result;
    }

    public static Object nullableDefaultValueMapper(String v, DefaultValueMapper mapper) throws Exception {
        int end;
        int start = v.lastIndexOf(40) == -1 ? 0 : v.lastIndexOf(40) + 1;
        String value = v.substring(start, end = !v.contains(")") ? v.length() : v.indexOf(41));
        if ("NULL".equalsIgnoreCase(value)) {
            return null;
        }
        return mapper.parse(value);
    }

    @FunctionalInterface
    private static interface DefaultValueMapper {
        public Object parse(String var1) throws Exception;
    }

    @FunctionalInterface
    static interface ConnectionProvider {
        public Connection get() throws SQLException;
    }
}

