/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.model.event;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.db.model.ChildPartition;
import io.debezium.connector.spanner.db.model.StreamEventMetadata;
import io.debezium.connector.spanner.db.model.event.ChangeStreamEvent;
import java.util.List;
import java.util.Objects;

public class ChildPartitionsEvent
implements ChangeStreamEvent {
    private final Timestamp startTimestamp;
    private final String recordSequence;
    private final List<ChildPartition> childPartitions;
    private final StreamEventMetadata metadata;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChildPartitionsEvent that = (ChildPartitionsEvent)o;
        if (!Objects.equals(this.startTimestamp, that.startTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.recordSequence, that.recordSequence)) {
            return false;
        }
        if (!Objects.equals(this.childPartitions, that.childPartitions)) {
            return false;
        }
        return Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        int result = this.startTimestamp != null ? this.startTimestamp.hashCode() : 0;
        result = 31 * result + (this.recordSequence != null ? this.recordSequence.hashCode() : 0);
        result = 31 * result + (this.childPartitions != null ? this.childPartitions.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public ChildPartitionsEvent(Timestamp startTimestamp, String recordSequence, List<ChildPartition> childPartitions, StreamEventMetadata metadata) {
        this.startTimestamp = startTimestamp;
        this.recordSequence = recordSequence;
        this.childPartitions = childPartitions;
        this.metadata = metadata;
    }

    @Override
    public Timestamp getRecordTimestamp() {
        return this.getStartTimestamp();
    }

    public Timestamp getStartTimestamp() {
        return this.startTimestamp;
    }

    public String getRecordSequence() {
        return this.recordSequence;
    }

    public List<ChildPartition> getChildPartitions() {
        return this.childPartitions;
    }

    @Override
    public StreamEventMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "ChildPartitionsEvent{startTimestamp=" + String.valueOf(this.startTimestamp) + ", recordSequence='" + this.recordSequence + "', childPartitions=" + String.valueOf(this.childPartitions) + ", metadata=" + String.valueOf(this.metadata) + "}";
    }
}

