/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import io.debezium.bean.StandardBeanNames;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.DebeziumHeaderProducer;
import io.debezium.connector.common.DebeziumHeaderProducerProvider;
import io.debezium.connector.spanner.Module;
import io.debezium.connector.spanner.SpannerBaseSourceTask;
import io.debezium.connector.spanner.SpannerChangeEventCreator;
import io.debezium.connector.spanner.SpannerChangeEventSourceCoordinator;
import io.debezium.connector.spanner.SpannerChangeEventSourceFactory;
import io.debezium.connector.spanner.SpannerConnector;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.SpannerErrorHandler;
import io.debezium.connector.spanner.config.SpannerTableFilter;
import io.debezium.connector.spanner.context.source.SourceInfoFactory;
import io.debezium.connector.spanner.context.source.SpannerSourceTaskContext;
import io.debezium.connector.spanner.db.DaoFactory;
import io.debezium.connector.spanner.db.DatabaseClientFactory;
import io.debezium.connector.spanner.db.SpannerChangeStreamFactory;
import io.debezium.connector.spanner.db.metadata.SchemaRegistry;
import io.debezium.connector.spanner.db.metadata.TableId;
import io.debezium.connector.spanner.db.stream.ChangeStream;
import io.debezium.connector.spanner.kafka.KafkaAdminClientFactory;
import io.debezium.connector.spanner.kafka.KafkaPartitionInfoProvider;
import io.debezium.connector.spanner.metrics.SpannerChangeEventSourceMetricsFactory;
import io.debezium.connector.spanner.metrics.SpannerMeter;
import io.debezium.connector.spanner.processor.SourceRecordUtils;
import io.debezium.connector.spanner.processor.SpannerEventDispatcher;
import io.debezium.connector.spanner.processor.heartbeat.SpannerHeartbeatFactory;
import io.debezium.connector.spanner.processor.metadata.SpannerEventMetadataProvider;
import io.debezium.connector.spanner.schema.KafkaSpannerSchema;
import io.debezium.connector.spanner.schema.KafkaSpannerTableSchemaFactory;
import io.debezium.connector.spanner.task.LowWatermarkHolder;
import io.debezium.connector.spanner.task.PartitionOffsetProvider;
import io.debezium.connector.spanner.task.SynchronizationTaskContext;
import io.debezium.connector.spanner.task.SynchronizedPartitionManager;
import io.debezium.connector.spanner.task.TaskUid;
import io.debezium.connector.spanner.task.state.TaskStateChangeEvent;
import io.debezium.function.BlockingConsumer;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.processors.PostProcessorRegistryServiceProvider;
import io.debezium.schema.DefaultTopicNamingStrategy;
import io.debezium.schema.SchemaFactory;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.service.spi.ServiceProvider;
import io.debezium.service.spi.ServiceRegistry;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.topic.TopicNamingStrategy;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.RetriableException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpannerConnectorTask
extends SpannerBaseSourceTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpannerConnectorTask.class);
    private static final String CONTEXT_NAME = "spanner-connector-task";
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile SynchronizationTaskContext synchronizationTaskContext;
    private volatile String taskUid;
    private volatile SpannerMeter spannerMeter;
    private volatile LowWatermarkHolder lowWatermarkHolder;
    private volatile KafkaAdminClientFactory adminClientFactory;
    private volatile ChangeStream changeStream;
    private volatile SpannerEventDispatcher dispatcher;
    private volatile KafkaSpannerSchema schema;
    private volatile boolean beganPolling = false;
    private SpannerErrorHandler errorHandler;

    protected SpannerChangeEventSourceCoordinator start(Configuration configuration) {
        SpannerConnectorConfig connectorConfig = new SpannerConnectorConfig(configuration);
        this.taskUid = TaskUid.generateTaskUid(connectorConfig.getConnectorName(), connectorConfig.getTaskId());
        LOGGER.info("Starting task with uid: {}", (Object)this.taskUid);
        DatabaseClientFactory databaseClientFactory = this.getDatabaseClientFactory(connectorConfig);
        DaoFactory daoFactory = new DaoFactory(databaseClientFactory);
        SpannerSourceTaskContext taskContext = new SpannerSourceTaskContext(connectorConfig, () -> this.spannerMeter.getCapturedTables());
        this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).maxQueueSizeInBytes(connectorConfig.getMaxQueueSizeInBytes()).loggingContextSupplier(() -> taskContext.configureLoggingContext(CONTEXT_NAME)).build();
        this.errorHandler = new SpannerErrorHandler(this, this.queue);
        this.spannerMeter = new SpannerMeter(this, connectorConfig, this.errorHandler, () -> this.lowWatermarkHolder.getLowWatermark());
        SchemaNameAdjuster schemaNameAdjuster = connectorConfig.schemaNameAdjuster();
        SpannerTableFilter tableFilter = new SpannerTableFilter(connectorConfig);
        SpannerEventMetadataProvider metadataProvider = new SpannerEventMetadataProvider();
        DefaultTopicNamingStrategy topicNamingStrategy = DefaultTopicNamingStrategy.create((CommonConnectorConfig)connectorConfig);
        SchemaRegistry schemaRegistry = new SchemaRegistry(connectorConfig.changeStreamName(), daoFactory.getSchemaDao(), () -> this.schema.resetCache());
        KafkaSpannerTableSchemaFactory tableSchemaFactory = new KafkaSpannerTableSchemaFactory((TopicNamingStrategy<TableId>)topicNamingStrategy, schemaNameAdjuster, schemaRegistry, connectorConfig.getSourceInfoStructMaker().schema());
        this.schema = new KafkaSpannerSchema(tableSchemaFactory);
        SpannerHeartbeatFactory spannerHeartbeatFactory = new SpannerHeartbeatFactory(connectorConfig, (TopicNamingStrategy)topicNamingStrategy, schemaNameAdjuster);
        PartitionOffsetProvider partitionOffsetProvider = new PartitionOffsetProvider(this.context.offsetStorageReader(), this.spannerMeter.getMetricsEventPublisher());
        SynchronizedPartitionManager partitionManager = new SynchronizedPartitionManager((BlockingConsumer<TaskStateChangeEvent>)((BlockingConsumer)event -> this.synchronizationTaskContext.publishEvent((TaskStateChangeEvent)event)));
        SpannerChangeStreamFactory spannerChangeStreamFactory = new SpannerChangeStreamFactory(this.taskUid, daoFactory, this.spannerMeter.getMetricsEventPublisher(), connectorConfig.getConnectorName(), databaseClientFactory);
        this.changeStream = spannerChangeStreamFactory.getStream(connectorConfig.changeStreamName(), connectorConfig.getHeartbeatInterval(), connectorConfig.getMaxMissedHeartbeats());
        this.lowWatermarkHolder = new LowWatermarkHolder();
        SourceInfoFactory sourceInfoFactory = new SourceInfoFactory(connectorConfig, this.lowWatermarkHolder);
        this.adminClientFactory = new KafkaAdminClientFactory(connectorConfig);
        KafkaPartitionInfoProvider kafkaPartitionInfoProvider = new KafkaPartitionInfoProvider(this.adminClientFactory.getAdminClient());
        connectorConfig.getBeanRegistry().add(StandardBeanNames.CONFIGURATION, (Object)configuration);
        connectorConfig.getBeanRegistry().add("ConnectorConfig", (Object)connectorConfig);
        connectorConfig.getBeanRegistry().add("Schema", (Object)this.schema);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.CDC_SOURCE_TASK_CONTEXT, (Object)taskContext);
        this.registerServiceProviders(connectorConfig.getServiceRegistry());
        this.dispatcher = new SpannerEventDispatcher(connectorConfig, (TopicNamingStrategy<TableId>)topicNamingStrategy, this.schema, this.queue, tableFilter, new SpannerChangeEventCreator(), metadataProvider, spannerHeartbeatFactory, schemaNameAdjuster, schemaRegistry, sourceInfoFactory, kafkaPartitionInfoProvider, (DebeziumHeaderProducer)connectorConfig.getServiceRegistry().tryGetService(DebeziumHeaderProducer.class));
        this.synchronizationTaskContext = new SynchronizationTaskContext(this, connectorConfig, this.errorHandler, partitionOffsetProvider, this.changeStream, this.dispatcher, this.adminClientFactory, schemaRegistry, this::finish, this.spannerMeter.getMetricsEventPublisher(), this.lowWatermarkHolder);
        SpannerChangeEventSourceFactory changeEventSourceFactory = new SpannerChangeEventSourceFactory(connectorConfig, this.dispatcher, this.errorHandler, schemaRegistry, this.spannerMeter, this.changeStream, sourceInfoFactory, partitionManager);
        NotificationService notificationService = new NotificationService(this.getNotificationChannels(), (CommonConnectorConfig)connectorConfig, SchemaFactory.get(), arg_0 -> ((SpannerEventDispatcher)this.dispatcher).enqueueNotification(arg_0));
        SnapshotterService snapshotterService = (SnapshotterService)connectorConfig.getServiceRegistry().tryGetService(SnapshotterService.class);
        this.coordinator = new SpannerChangeEventSourceCoordinator(this.getInitialOffsets(), this.errorHandler, SpannerConnector.class, connectorConfig, changeEventSourceFactory, (ChangeEventSourceMetricsFactory)new SpannerChangeEventSourceMetricsFactory(this.spannerMeter), this.dispatcher, this.schema, notificationService, snapshotterService);
        this.spannerMeter.start();
        this.coordinator.start(taskContext, (ChangeEventQueueMetrics)this.queue, metadataProvider);
        this.synchronizationTaskContext.init();
        LOGGER.info("Finished starting task {}", (Object)this.taskUid);
        return this.coordinator;
    }

    protected String connectorName() {
        return Module.name();
    }

    DatabaseClientFactory getDatabaseClientFactory(SpannerConnectorConfig connectorConfig) {
        return new DatabaseClientFactory(connectorConfig);
    }

    protected List<SourceRecord> doPoll() throws InterruptedException {
        if (!this.beganPolling) {
            this.beganPolling = true;
            LOGGER.info("Task {}, began polling", (Object)this.taskUid);
        }
        List records = this.queue.poll();
        long pollAtTimestamp = Instant.now().toEpochMilli();
        List<SourceRecord> resultedRecords = records.stream().map(DataChangeEvent::getRecord).map(record -> SourceRecordUtils.addPollTimestamp(record, pollAtTimestamp)).collect(Collectors.toList());
        if (!resultedRecords.isEmpty()) {
            LOGGER.debug("Records sent to Kafka: {}", resultedRecords);
        }
        return resultedRecords;
    }

    protected Optional<ErrorHandler> getErrorHandler() {
        return Optional.of(this.errorHandler);
    }

    @Override
    protected void onRecordSent(SourceRecord sourceRecord) {
        this.spannerMeter.getMetricsEventPublisher().logLatency(sourceRecord);
    }

    protected void doStop() {
        LOGGER.info("Stopping task {}, changeStream", (Object)this.taskUid);
        this.changeStream.stop();
        LOGGER.info("Stopping task {}, synchronizationTaskContext", (Object)this.taskUid);
        this.synchronizationTaskContext.destroy();
        LOGGER.info("Stopping task {}, dispatcher", (Object)this.taskUid);
        this.dispatcher.destroy();
        LOGGER.info("Stopping task {}, adminClientFactory", (Object)this.taskUid);
        this.adminClientFactory.close();
        LOGGER.info("Stopping task {}, spannerMeter", (Object)this.taskUid);
        this.spannerMeter.shutdown();
        LOGGER.info("Task {} was stopped", (Object)this.taskUid);
    }

    public void finish() {
        this.queue.producerException((RuntimeException)new ConnectException("Task " + this.taskUid + " finished work"));
    }

    public void restart() {
        this.queue.producerException((RuntimeException)new RetriableException("Task " + this.taskUid + " will be restarted"));
    }

    public String getTaskUid() {
        return this.taskUid;
    }

    protected void registerServiceProviders(ServiceRegistry serviceRegistry) {
        serviceRegistry.registerServiceProvider((ServiceProvider)new PostProcessorRegistryServiceProvider());
        serviceRegistry.registerServiceProvider((ServiceProvider)new DebeziumHeaderProducerProvider());
    }
}

