/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.operation;

import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.operation.Operation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindPartitionForStreamingOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(FindPartitionForStreamingOperation.class);
    private boolean isRequiredPublishSyncEvent = false;

    private TaskSyncContext takePartitionForStreaming(TaskSyncContext taskSyncContext) {
        Set<String> allPartitions = this.getAllPartitions(taskSyncContext);
        Set<String> finishedPartitions = this.getFinishedPartitions(taskSyncContext);
        TaskState taskState = taskSyncContext.getCurrentTaskState();
        List<PartitionState> partitions = taskState.getPartitions().stream().map(partitionState -> {
            if (partitionState.getState().equals((Object)PartitionStateEnum.CREATED)) {
                boolean takePartitionForStreaming = false;
                LOGGER.debug("Task sees partition with CREATED state, task Uid {}, partition {}", (Object)taskSyncContext.getTaskUid(), partitionState);
                if (finishedPartitions.containsAll(partitionState.getParents())) {
                    takePartitionForStreaming = true;
                    LOGGER.info("Task takes partition for streaming, taskUid: {}, partition {}", (Object)taskSyncContext.getTaskUid(), (Object)partitionState.getToken());
                } else if (!this.atLeastOneParentExists(taskSyncContext, partitionState.getParents())) {
                    LOGGER.info("Task takes partition for streaming, since parents no longer exist, taskUid: {}, partition {}, parents {}", new Object[]{taskSyncContext.getTaskUid(), partitionState.getToken(), partitionState.getParents()});
                    takePartitionForStreaming = true;
                } else {
                    LOGGER.info("Task not taking partition for streaming, since parents are not finished, taskUid: {}, partition {}, parents {}", new Object[]{taskSyncContext.getTaskUid(), partitionState.getToken(), partitionState.getParents()});
                }
                if (takePartitionForStreaming) {
                    this.isRequiredPublishSyncEvent = true;
                    return partitionState.toBuilder().state(PartitionStateEnum.READY_FOR_STREAMING).build();
                }
                return partitionState;
            }
            return partitionState;
        }).collect(Collectors.toList());
        return taskSyncContext.toBuilder().currentTaskState(taskState.toBuilder().partitions(partitions).build()).build();
    }

    private Set<String> getFinishedPartitions(TaskSyncContext taskSyncContext) {
        ArrayList<PartitionState> partitionStateList = new ArrayList<PartitionState>();
        partitionStateList.addAll(taskSyncContext.getCurrentTaskState().getPartitions());
        partitionStateList.addAll(taskSyncContext.getTaskStates().values().stream().flatMap(taskState -> taskState.getPartitions().stream()).collect(Collectors.toList()));
        return partitionStateList.stream().filter(partitionState -> PartitionStateEnum.FINISHED.equals((Object)partitionState.getState()) || PartitionStateEnum.REMOVED.equals((Object)partitionState.getState())).map(PartitionState::getToken).collect(Collectors.toSet());
    }

    private Set<String> getAllPartitions(TaskSyncContext taskSyncContext) {
        ArrayList<PartitionState> partitionStateList = new ArrayList<PartitionState>();
        partitionStateList.addAll(taskSyncContext.getCurrentTaskState().getPartitions());
        partitionStateList.addAll(taskSyncContext.getTaskStates().values().stream().flatMap(taskState -> taskState.getPartitions().stream()).collect(Collectors.toList()));
        partitionStateList.addAll(taskSyncContext.getCurrentTaskState().getSharedPartitions());
        partitionStateList.addAll(taskSyncContext.getTaskStates().values().stream().flatMap(taskState -> taskState.getSharedPartitions().stream()).collect(Collectors.toList()));
        return partitionStateList.stream().map(PartitionState::getToken).collect(Collectors.toSet());
    }

    private boolean atLeastOneParentExists(TaskSyncContext taskSyncContext, Set<String> parents) {
        ArrayList<PartitionState> partitionStateList = new ArrayList<PartitionState>();
        partitionStateList.addAll(taskSyncContext.getCurrentTaskState().getPartitions());
        partitionStateList.addAll(taskSyncContext.getTaskStates().values().stream().flatMap(taskState -> taskState.getPartitions().stream()).collect(Collectors.toList()));
        partitionStateList.addAll(taskSyncContext.getCurrentTaskState().getSharedPartitions());
        partitionStateList.addAll(taskSyncContext.getTaskStates().values().stream().flatMap(taskState -> taskState.getSharedPartitions().stream()).collect(Collectors.toList()));
        Set allPartitions = partitionStateList.stream().map(PartitionState::getToken).collect(Collectors.toSet());
        for (String parent : parents) {
            if (!allPartitions.contains(parent)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRequiredPublishSyncEvent() {
        return this.isRequiredPublishSyncEvent;
    }

    @Override
    public TaskSyncContext doOperation(TaskSyncContext taskSyncContext) {
        return this.takePartitionForStreaming(taskSyncContext);
    }
}

