/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.config.validation;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.config.validation.ChangeStreamValidator;
import io.debezium.connector.spanner.config.validation.ConnectionValidator;
import io.debezium.connector.spanner.config.validation.StartEndTimeValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigValue;

public class ConfigurationValidator {
    private ConfigurationValidator() {
    }

    public static Config validate(Map<String, String> connectorConfigs) {
        Configuration config = Configuration.from(connectorConfigs);
        Map results = config.validate(SpannerConnectorConfig.ALL_FIELDS);
        ValidationContext validationContext = new ValidationContext(config, results);
        ConnectionValidator.withContext(validationContext).validate().then(ChangeStreamValidator.withContext(validationContext));
        StartEndTimeValidator.withContext(validationContext).validate();
        return new Config(validationContext.getResults());
    }

    public static class ValidationContext {
        private final Configuration config;
        private final Map<String, ConfigValue> configValueMap;

        public ValidationContext(Configuration config, Map<String, ConfigValue> configValueMap) {
            this.config = config;
            this.configValueMap = configValueMap;
        }

        public String getString(Field field) {
            return this.config.getString(field);
        }

        public List<String> getErrors(Field field) {
            return this.configValueMap.get(field.name()).errorMessages();
        }

        public void error(String message, Field ... fields) {
            if (fields.length == 0) {
                throw new IllegalArgumentException("fields must be specified");
            }
            for (Field field : fields) {
                this.configValueMap.get(field.name()).addErrorMessage(message);
            }
        }

        public List<ConfigValue> getResults() {
            return new ArrayList<ConfigValue>(this.configValueMap.values());
        }
    }

    public static interface Validator {
        public Validator validate();

        public boolean isSuccess();

        default public Validator then(Validator validator) {
            if (this.isSuccess()) {
                return validator.validate();
            }
            return this;
        }
    }
}

