/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.context.offset;

import io.debezium.connector.spanner.context.offset.PartitionOffset;
import io.debezium.connector.spanner.context.offset.SpannerOffsetContext;
import io.debezium.connector.spanner.context.source.SourceInfo;
import io.debezium.connector.spanner.context.source.SourceInfoFactory;
import io.debezium.connector.spanner.db.model.event.DataChangeEvent;
import io.debezium.connector.spanner.db.model.event.HeartbeatEvent;
import io.debezium.pipeline.txmetadata.TransactionContext;

public class SpannerOffsetContextFactory {
    private final SourceInfoFactory sourceInfoFactory;
    private final TransactionContext transactionContext;

    public SpannerOffsetContextFactory(SourceInfoFactory sourceInfoFactory) {
        this.sourceInfoFactory = sourceInfoFactory;
        this.transactionContext = new TransactionContext();
    }

    public SpannerOffsetContext getOffsetContextFromDataChangeEvent(int modNumber, DataChangeEvent dataChangeEvent) throws InterruptedException {
        SourceInfo sourceInfo = this.sourceInfoFactory.getSourceInfo(modNumber, dataChangeEvent);
        PartitionOffset partitionOffset = new PartitionOffset(dataChangeEvent.getCommitTimestamp(), dataChangeEvent.getMetadata());
        return new SpannerOffsetContext(sourceInfo, partitionOffset, this.transactionContext);
    }

    public SpannerOffsetContext getOffsetContextFromHeartbeatEvent(HeartbeatEvent heartbeatEvent) {
        PartitionOffset partitionOffset = new PartitionOffset(heartbeatEvent.getRecordTimestamp(), heartbeatEvent.getMetadata());
        return new SpannerOffsetContext(partitionOffset, this.transactionContext);
    }
}

