/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.model;

import com.google.cloud.Timestamp;
import java.util.Objects;
import javax.annotation.Nullable;

public class StreamEventMetadata {
    private String partitionToken;
    private Timestamp recordTimestamp;
    private Timestamp partitionStartTimestamp;
    private Timestamp partitionEndTimestamp;
    private Timestamp queryStartedAt;
    private Timestamp recordStreamStartedAt;
    private Timestamp recordStreamEndedAt;
    private Timestamp recordReadAt;
    private long totalStreamTimeMillis;
    private long numberOfRecordsRead;

    private StreamEventMetadata() {
    }

    private StreamEventMetadata(String partitionToken, Timestamp recordTimestamp, Timestamp partitionStartTimestamp, Timestamp partitionEndTimestamp, Timestamp queryStartedAt, Timestamp recordStreamStartedAt, Timestamp recordStreamEndedAt, Timestamp recordReadAt, long totalStreamTimeMillis, long numberOfRecordsRead) {
        this.partitionToken = partitionToken;
        this.recordTimestamp = recordTimestamp;
        this.partitionStartTimestamp = partitionStartTimestamp;
        this.partitionEndTimestamp = partitionEndTimestamp;
        this.queryStartedAt = queryStartedAt;
        this.recordStreamStartedAt = recordStreamStartedAt;
        this.recordStreamEndedAt = recordStreamEndedAt;
        this.recordReadAt = recordReadAt;
        this.totalStreamTimeMillis = totalStreamTimeMillis;
        this.numberOfRecordsRead = numberOfRecordsRead;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getPartitionToken() {
        return this.partitionToken;
    }

    public Timestamp getRecordTimestamp() {
        return this.recordTimestamp;
    }

    public Timestamp getPartitionStartTimestamp() {
        return this.partitionStartTimestamp;
    }

    public Timestamp getPartitionEndTimestamp() {
        return this.partitionEndTimestamp;
    }

    public Timestamp getQueryStartedAt() {
        return this.queryStartedAt;
    }

    public Timestamp getRecordStreamStartedAt() {
        return this.recordStreamStartedAt;
    }

    public Timestamp getRecordStreamEndedAt() {
        return this.recordStreamEndedAt;
    }

    public Timestamp getRecordReadAt() {
        return this.recordReadAt;
    }

    public long getTotalStreamTimeMillis() {
        return this.totalStreamTimeMillis;
    }

    public long getNumberOfRecordsRead() {
        return this.numberOfRecordsRead;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamEventMetadata)) {
            return false;
        }
        StreamEventMetadata metadata = (StreamEventMetadata)o;
        return this.totalStreamTimeMillis == metadata.totalStreamTimeMillis && this.numberOfRecordsRead == metadata.numberOfRecordsRead && Objects.equals(this.partitionToken, metadata.partitionToken) && Objects.equals(this.recordTimestamp, metadata.recordTimestamp) && Objects.equals(this.partitionStartTimestamp, metadata.partitionStartTimestamp) && Objects.equals(this.partitionEndTimestamp, metadata.partitionEndTimestamp) && Objects.equals(this.queryStartedAt, metadata.queryStartedAt) && Objects.equals(this.recordStreamStartedAt, metadata.recordStreamStartedAt) && Objects.equals(this.recordStreamEndedAt, metadata.recordStreamEndedAt) && Objects.equals(this.recordReadAt, metadata.recordReadAt);
    }

    public int hashCode() {
        return Objects.hash(this.partitionToken, this.recordTimestamp, this.partitionStartTimestamp, this.partitionEndTimestamp, this.queryStartedAt, this.recordStreamStartedAt, this.recordStreamEndedAt, this.recordReadAt, this.totalStreamTimeMillis, this.numberOfRecordsRead);
    }

    public String toString() {
        return "ChangeStreamRecordMetadata{partitionToken='" + this.partitionToken + "', recordTimestamp=" + String.valueOf(this.recordTimestamp) + ", partitionStartTimestamp=" + String.valueOf(this.partitionStartTimestamp) + ", partitionEndTimestamp=" + String.valueOf(this.partitionEndTimestamp) + ", queryStartedAt=" + String.valueOf(this.queryStartedAt) + ", recordStreamStartedAt=" + String.valueOf(this.recordStreamStartedAt) + ", recordStreamEndedAt=" + String.valueOf(this.recordStreamEndedAt) + ", recordReadAt=" + String.valueOf(this.recordReadAt) + ", totalStreamTimeMillis=" + this.totalStreamTimeMillis + ", numberOfRecordsRead=" + this.numberOfRecordsRead + "}";
    }

    public static class Builder {
        private String partitionToken;
        private Timestamp recordTimestamp;
        private Timestamp partitionStartTimestamp;
        private Timestamp partitionEndTimestamp;
        private Timestamp queryStartedAt;
        private Timestamp recordStreamStartedAt;
        private Timestamp recordStreamEndedAt;
        private Timestamp recordReadAt;
        private long totalStreamTimeMillis;
        private long numberOfRecordsRead;

        public Builder withPartitionToken(String partitionToken) {
            this.partitionToken = partitionToken;
            return this;
        }

        public Builder withRecordTimestamp(Timestamp recordTimestamp) {
            this.recordTimestamp = recordTimestamp;
            return this;
        }

        public Builder withPartitionStartTimestamp(Timestamp partitionStartTimestamp) {
            this.partitionStartTimestamp = partitionStartTimestamp;
            return this;
        }

        public Builder withPartitionEndTimestamp(Timestamp partitionEndTimestamp) {
            this.partitionEndTimestamp = partitionEndTimestamp;
            return this;
        }

        public Builder withQueryStartedAt(Timestamp queryStartedAt) {
            this.queryStartedAt = queryStartedAt;
            return this;
        }

        public Builder withRecordStreamStartedAt(Timestamp recordStreamStartedAt) {
            this.recordStreamStartedAt = recordStreamStartedAt;
            return this;
        }

        public Builder withRecordStreamEndedAt(Timestamp recordStreamEndedAt) {
            this.recordStreamEndedAt = recordStreamEndedAt;
            return this;
        }

        public Builder withRecordReadAt(Timestamp recordReadAt) {
            this.recordReadAt = recordReadAt;
            return this;
        }

        public Builder withTotalStreamTimeMillis(long totalStreamTimeMillis) {
            this.totalStreamTimeMillis = totalStreamTimeMillis;
            return this;
        }

        public Builder withNumberOfRecordsRead(long numberOfRecordsRead) {
            this.numberOfRecordsRead = numberOfRecordsRead;
            return this;
        }

        public StreamEventMetadata build() {
            return new StreamEventMetadata(this.partitionToken, this.recordTimestamp, this.partitionStartTimestamp, this.partitionEndTimestamp, this.queryStartedAt, this.recordStreamStartedAt, this.recordStreamEndedAt, this.recordReadAt, this.totalStreamTimeMillis, this.numberOfRecordsRead);
        }
    }
}

